/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.DomainEntry;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteDomainEntryRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, DeleteDomainEntryRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainName").getter(DeleteDomainEntryRequest.getter(DeleteDomainEntryRequest::domainName)).setter(DeleteDomainEntryRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()}).build();
    private static final SdkField<DomainEntry> DOMAIN_ENTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("domainEntry").getter(DeleteDomainEntryRequest.getter(DeleteDomainEntryRequest::domainEntry)).setter(DeleteDomainEntryRequest.setter(Builder::domainEntry)).constructor(DomainEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainEntry").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, DOMAIN_ENTRY_FIELD));
    private final String domainName;
    private final DomainEntry domainEntry;

    private DeleteDomainEntryRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.domainEntry = builder.domainEntry;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final DomainEntry domainEntry() {
        return this.domainEntry;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainEntry());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDomainEntryRequest)) {
            return false;
        }
        DeleteDomainEntryRequest other = (DeleteDomainEntryRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.domainEntry(), other.domainEntry());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteDomainEntryRequest").add("DomainName", (Object)this.domainName()).add("DomainEntry", (Object)this.domainEntry()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "domainEntry": {
                return Optional.ofNullable(clazz.cast(this.domainEntry()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteDomainEntryRequest, T> g) {
        return obj -> g.apply((DeleteDomainEntryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private DomainEntry domainEntry;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDomainEntryRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.domainEntry(model.domainEntry);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        @Transient
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final DomainEntry.Builder getDomainEntry() {
            return this.domainEntry != null ? this.domainEntry.toBuilder() : null;
        }

        public final void setDomainEntry(DomainEntry.BuilderImpl domainEntry) {
            this.domainEntry = domainEntry != null ? domainEntry.build() : null;
        }

        @Override
        @Transient
        public final Builder domainEntry(DomainEntry domainEntry) {
            this.domainEntry = domainEntry;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteDomainEntryRequest build() {
            return new DeleteDomainEntryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteDomainEntryRequest> {
        public Builder domainName(String var1);

        public Builder domainEntry(DomainEntry var1);

        default public Builder domainEntry(Consumer<DomainEntry.Builder> domainEntry) {
            return this.domainEntry((DomainEntry)((DomainEntry.Builder)DomainEntry.builder().applyMutation(domainEntry)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

