/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InstancePlatform {
    LINUX_UNIX("LINUX_UNIX"),
    WINDOWS("WINDOWS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InstancePlatform> VALUE_MAP;
    private final String value;

    private InstancePlatform(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InstancePlatform fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InstancePlatform> knownValues() {
        EnumSet<InstancePlatform> knownValues = EnumSet.allOf(InstancePlatform.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InstancePlatform.class, InstancePlatform::toString);
    }
}

