/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum IpAddressType {
    DUALSTACK("dualstack"),
    IPV4("ipv4"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private IpAddressType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IpAddressType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(IpAddressType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IpAddressType> knownValues() {
        return Stream.of(IpAddressType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

