/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.AddOnRequest;
import software.amazon.awssdk.services.lightsail.model.AddOnRequestListCopier;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.services.lightsail.model.Tag;
import software.amazon.awssdk.services.lightsail.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDiskFromSnapshotRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, CreateDiskFromSnapshotRequest> {
    private static final SdkField<String> DISK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("diskName").getter(CreateDiskFromSnapshotRequest.getter(CreateDiskFromSnapshotRequest::diskName)).setter(CreateDiskFromSnapshotRequest.setter(Builder::diskName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("diskName").build()}).build();
    private static final SdkField<String> DISK_SNAPSHOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("diskSnapshotName").getter(CreateDiskFromSnapshotRequest.getter(CreateDiskFromSnapshotRequest::diskSnapshotName)).setter(CreateDiskFromSnapshotRequest.setter(Builder::diskSnapshotName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("diskSnapshotName").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("availabilityZone").getter(CreateDiskFromSnapshotRequest.getter(CreateDiskFromSnapshotRequest::availabilityZone)).setter(CreateDiskFromSnapshotRequest.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()}).build();
    private static final SdkField<Integer> SIZE_IN_GB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("sizeInGb").getter(CreateDiskFromSnapshotRequest.getter(CreateDiskFromSnapshotRequest::sizeInGb)).setter(CreateDiskFromSnapshotRequest.setter(Builder::sizeInGb)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sizeInGb").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateDiskFromSnapshotRequest.getter(CreateDiskFromSnapshotRequest::tags)).setter(CreateDiskFromSnapshotRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AddOnRequest>> ADD_ONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("addOns").getter(CreateDiskFromSnapshotRequest.getter(CreateDiskFromSnapshotRequest::addOns)).setter(CreateDiskFromSnapshotRequest.setter(Builder::addOns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addOns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AddOnRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SOURCE_DISK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceDiskName").getter(CreateDiskFromSnapshotRequest.getter(CreateDiskFromSnapshotRequest::sourceDiskName)).setter(CreateDiskFromSnapshotRequest.setter(Builder::sourceDiskName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceDiskName").build()}).build();
    private static final SdkField<String> RESTORE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("restoreDate").getter(CreateDiskFromSnapshotRequest.getter(CreateDiskFromSnapshotRequest::restoreDate)).setter(CreateDiskFromSnapshotRequest.setter(Builder::restoreDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("restoreDate").build()}).build();
    private static final SdkField<Boolean> USE_LATEST_RESTORABLE_AUTO_SNAPSHOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("useLatestRestorableAutoSnapshot").getter(CreateDiskFromSnapshotRequest.getter(CreateDiskFromSnapshotRequest::useLatestRestorableAutoSnapshot)).setter(CreateDiskFromSnapshotRequest.setter(Builder::useLatestRestorableAutoSnapshot)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("useLatestRestorableAutoSnapshot").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISK_NAME_FIELD, DISK_SNAPSHOT_NAME_FIELD, AVAILABILITY_ZONE_FIELD, SIZE_IN_GB_FIELD, TAGS_FIELD, ADD_ONS_FIELD, SOURCE_DISK_NAME_FIELD, RESTORE_DATE_FIELD, USE_LATEST_RESTORABLE_AUTO_SNAPSHOT_FIELD));
    private final String diskName;
    private final String diskSnapshotName;
    private final String availabilityZone;
    private final Integer sizeInGb;
    private final List<Tag> tags;
    private final List<AddOnRequest> addOns;
    private final String sourceDiskName;
    private final String restoreDate;
    private final Boolean useLatestRestorableAutoSnapshot;

    private CreateDiskFromSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.diskName = builder.diskName;
        this.diskSnapshotName = builder.diskSnapshotName;
        this.availabilityZone = builder.availabilityZone;
        this.sizeInGb = builder.sizeInGb;
        this.tags = builder.tags;
        this.addOns = builder.addOns;
        this.sourceDiskName = builder.sourceDiskName;
        this.restoreDate = builder.restoreDate;
        this.useLatestRestorableAutoSnapshot = builder.useLatestRestorableAutoSnapshot;
    }

    public final String diskName() {
        return this.diskName;
    }

    public final String diskSnapshotName() {
        return this.diskSnapshotName;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final Integer sizeInGb() {
        return this.sizeInGb;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final boolean hasAddOns() {
        return this.addOns != null && !(this.addOns instanceof SdkAutoConstructList);
    }

    public final List<AddOnRequest> addOns() {
        return this.addOns;
    }

    public final String sourceDiskName() {
        return this.sourceDiskName;
    }

    public final String restoreDate() {
        return this.restoreDate;
    }

    public final Boolean useLatestRestorableAutoSnapshot() {
        return this.useLatestRestorableAutoSnapshot;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.diskName());
        hashCode = 31 * hashCode + Objects.hashCode(this.diskSnapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeInGb());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddOns() ? this.addOns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDiskName());
        hashCode = 31 * hashCode + Objects.hashCode(this.restoreDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.useLatestRestorableAutoSnapshot());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDiskFromSnapshotRequest)) {
            return false;
        }
        CreateDiskFromSnapshotRequest other = (CreateDiskFromSnapshotRequest)((Object)obj);
        return Objects.equals(this.diskName(), other.diskName()) && Objects.equals(this.diskSnapshotName(), other.diskSnapshotName()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.sizeInGb(), other.sizeInGb()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasAddOns() == other.hasAddOns() && Objects.equals(this.addOns(), other.addOns()) && Objects.equals(this.sourceDiskName(), other.sourceDiskName()) && Objects.equals(this.restoreDate(), other.restoreDate()) && Objects.equals(this.useLatestRestorableAutoSnapshot(), other.useLatestRestorableAutoSnapshot());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDiskFromSnapshotRequest").add("DiskName", (Object)this.diskName()).add("DiskSnapshotName", (Object)this.diskSnapshotName()).add("AvailabilityZone", (Object)this.availabilityZone()).add("SizeInGb", (Object)this.sizeInGb()).add("Tags", this.hasTags() ? this.tags() : null).add("AddOns", this.hasAddOns() ? this.addOns() : null).add("SourceDiskName", (Object)this.sourceDiskName()).add("RestoreDate", (Object)this.restoreDate()).add("UseLatestRestorableAutoSnapshot", (Object)this.useLatestRestorableAutoSnapshot()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "diskName": {
                return Optional.ofNullable(clazz.cast(this.diskName()));
            }
            case "diskSnapshotName": {
                return Optional.ofNullable(clazz.cast(this.diskSnapshotName()));
            }
            case "availabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "sizeInGb": {
                return Optional.ofNullable(clazz.cast(this.sizeInGb()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "addOns": {
                return Optional.ofNullable(clazz.cast(this.addOns()));
            }
            case "sourceDiskName": {
                return Optional.ofNullable(clazz.cast(this.sourceDiskName()));
            }
            case "restoreDate": {
                return Optional.ofNullable(clazz.cast(this.restoreDate()));
            }
            case "useLatestRestorableAutoSnapshot": {
                return Optional.ofNullable(clazz.cast(this.useLatestRestorableAutoSnapshot()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDiskFromSnapshotRequest, T> g) {
        return obj -> g.apply((CreateDiskFromSnapshotRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private String diskName;
        private String diskSnapshotName;
        private String availabilityZone;
        private Integer sizeInGb;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private List<AddOnRequest> addOns = DefaultSdkAutoConstructList.getInstance();
        private String sourceDiskName;
        private String restoreDate;
        private Boolean useLatestRestorableAutoSnapshot;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDiskFromSnapshotRequest model) {
            super(model);
            this.diskName(model.diskName);
            this.diskSnapshotName(model.diskSnapshotName);
            this.availabilityZone(model.availabilityZone);
            this.sizeInGb(model.sizeInGb);
            this.tags(model.tags);
            this.addOns(model.addOns);
            this.sourceDiskName(model.sourceDiskName);
            this.restoreDate(model.restoreDate);
            this.useLatestRestorableAutoSnapshot(model.useLatestRestorableAutoSnapshot);
        }

        public final String getDiskName() {
            return this.diskName;
        }

        @Override
        public final Builder diskName(String diskName) {
            this.diskName = diskName;
            return this;
        }

        public final void setDiskName(String diskName) {
            this.diskName = diskName;
        }

        public final String getDiskSnapshotName() {
            return this.diskSnapshotName;
        }

        @Override
        public final Builder diskSnapshotName(String diskSnapshotName) {
            this.diskSnapshotName = diskSnapshotName;
            return this;
        }

        public final void setDiskSnapshotName(String diskSnapshotName) {
            this.diskSnapshotName = diskSnapshotName;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Integer getSizeInGb() {
            return this.sizeInGb;
        }

        @Override
        public final Builder sizeInGb(Integer sizeInGb) {
            this.sizeInGb = sizeInGb;
            return this;
        }

        public final void setSizeInGb(Integer sizeInGb) {
            this.sizeInGb = sizeInGb;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final List<AddOnRequest.Builder> getAddOns() {
            List<AddOnRequest.Builder> result = AddOnRequestListCopier.copyToBuilder(this.addOns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder addOns(Collection<AddOnRequest> addOns) {
            this.addOns = AddOnRequestListCopier.copy(addOns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addOns(AddOnRequest ... addOns) {
            this.addOns(Arrays.asList(addOns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addOns(Consumer<AddOnRequest.Builder> ... addOns) {
            this.addOns(Stream.of(addOns).map(c -> (AddOnRequest)((AddOnRequest.Builder)AddOnRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAddOns(Collection<AddOnRequest.BuilderImpl> addOns) {
            this.addOns = AddOnRequestListCopier.copyFromBuilder(addOns);
        }

        public final String getSourceDiskName() {
            return this.sourceDiskName;
        }

        @Override
        public final Builder sourceDiskName(String sourceDiskName) {
            this.sourceDiskName = sourceDiskName;
            return this;
        }

        public final void setSourceDiskName(String sourceDiskName) {
            this.sourceDiskName = sourceDiskName;
        }

        public final String getRestoreDate() {
            return this.restoreDate;
        }

        @Override
        public final Builder restoreDate(String restoreDate) {
            this.restoreDate = restoreDate;
            return this;
        }

        public final void setRestoreDate(String restoreDate) {
            this.restoreDate = restoreDate;
        }

        public final Boolean getUseLatestRestorableAutoSnapshot() {
            return this.useLatestRestorableAutoSnapshot;
        }

        @Override
        public final Builder useLatestRestorableAutoSnapshot(Boolean useLatestRestorableAutoSnapshot) {
            this.useLatestRestorableAutoSnapshot = useLatestRestorableAutoSnapshot;
            return this;
        }

        public final void setUseLatestRestorableAutoSnapshot(Boolean useLatestRestorableAutoSnapshot) {
            this.useLatestRestorableAutoSnapshot = useLatestRestorableAutoSnapshot;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDiskFromSnapshotRequest build() {
            return new CreateDiskFromSnapshotRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDiskFromSnapshotRequest> {
        public Builder diskName(String var1);

        public Builder diskSnapshotName(String var1);

        public Builder availabilityZone(String var1);

        public Builder sizeInGb(Integer var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder addOns(Collection<AddOnRequest> var1);

        public Builder addOns(AddOnRequest ... var1);

        public Builder addOns(Consumer<AddOnRequest.Builder> ... var1);

        public Builder sourceDiskName(String var1);

        public Builder restoreDate(String var1);

        public Builder useLatestRestorableAutoSnapshot(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

