/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.CertificateStatus;
import software.amazon.awssdk.services.lightsail.model.CertificateStatusListCopier;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCertificatesRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, GetCertificatesRequest> {
    private static final SdkField<List<String>> CERTIFICATE_STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("certificateStatuses").getter(GetCertificatesRequest.getter(GetCertificatesRequest::certificateStatusesAsStrings)).setter(GetCertificatesRequest.setter(Builder::certificateStatusesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateStatuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> INCLUDE_CERTIFICATE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("includeCertificateDetails").getter(GetCertificatesRequest.getter(GetCertificatesRequest::includeCertificateDetails)).setter(GetCertificatesRequest.setter(Builder::includeCertificateDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeCertificateDetails").build()}).build();
    private static final SdkField<String> CERTIFICATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("certificateName").getter(GetCertificatesRequest.getter(GetCertificatesRequest::certificateName)).setter(GetCertificatesRequest.setter(Builder::certificateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_STATUSES_FIELD, INCLUDE_CERTIFICATE_DETAILS_FIELD, CERTIFICATE_NAME_FIELD));
    private final List<String> certificateStatuses;
    private final Boolean includeCertificateDetails;
    private final String certificateName;

    private GetCertificatesRequest(BuilderImpl builder) {
        super(builder);
        this.certificateStatuses = builder.certificateStatuses;
        this.includeCertificateDetails = builder.includeCertificateDetails;
        this.certificateName = builder.certificateName;
    }

    public final List<CertificateStatus> certificateStatuses() {
        return CertificateStatusListCopier.copyStringToEnum(this.certificateStatuses);
    }

    public final boolean hasCertificateStatuses() {
        return this.certificateStatuses != null && !(this.certificateStatuses instanceof SdkAutoConstructList);
    }

    public final List<String> certificateStatusesAsStrings() {
        return this.certificateStatuses;
    }

    public final Boolean includeCertificateDetails() {
        return this.includeCertificateDetails;
    }

    public final String certificateName() {
        return this.certificateName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCertificateStatuses() ? this.certificateStatusesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.includeCertificateDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCertificatesRequest)) {
            return false;
        }
        GetCertificatesRequest other = (GetCertificatesRequest)((Object)obj);
        return this.hasCertificateStatuses() == other.hasCertificateStatuses() && Objects.equals(this.certificateStatusesAsStrings(), other.certificateStatusesAsStrings()) && Objects.equals(this.includeCertificateDetails(), other.includeCertificateDetails()) && Objects.equals(this.certificateName(), other.certificateName());
    }

    public final String toString() {
        return ToString.builder((String)"GetCertificatesRequest").add("CertificateStatuses", this.hasCertificateStatuses() ? this.certificateStatusesAsStrings() : null).add("IncludeCertificateDetails", (Object)this.includeCertificateDetails()).add("CertificateName", (Object)this.certificateName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "certificateStatuses": {
                return Optional.ofNullable(clazz.cast(this.certificateStatusesAsStrings()));
            }
            case "includeCertificateDetails": {
                return Optional.ofNullable(clazz.cast(this.includeCertificateDetails()));
            }
            case "certificateName": {
                return Optional.ofNullable(clazz.cast(this.certificateName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCertificatesRequest, T> g) {
        return obj -> g.apply((GetCertificatesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private List<String> certificateStatuses = DefaultSdkAutoConstructList.getInstance();
        private Boolean includeCertificateDetails;
        private String certificateName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCertificatesRequest model) {
            super(model);
            this.certificateStatusesWithStrings(model.certificateStatuses);
            this.includeCertificateDetails(model.includeCertificateDetails);
            this.certificateName(model.certificateName);
        }

        public final Collection<String> getCertificateStatuses() {
            if (this.certificateStatuses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.certificateStatuses;
        }

        @Override
        public final Builder certificateStatusesWithStrings(Collection<String> certificateStatuses) {
            this.certificateStatuses = CertificateStatusListCopier.copy(certificateStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificateStatusesWithStrings(String ... certificateStatuses) {
            this.certificateStatusesWithStrings(Arrays.asList(certificateStatuses));
            return this;
        }

        @Override
        public final Builder certificateStatuses(Collection<CertificateStatus> certificateStatuses) {
            this.certificateStatuses = CertificateStatusListCopier.copyEnumToString(certificateStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificateStatuses(CertificateStatus ... certificateStatuses) {
            this.certificateStatuses(Arrays.asList(certificateStatuses));
            return this;
        }

        public final void setCertificateStatuses(Collection<String> certificateStatuses) {
            this.certificateStatuses = CertificateStatusListCopier.copy(certificateStatuses);
        }

        public final Boolean getIncludeCertificateDetails() {
            return this.includeCertificateDetails;
        }

        @Override
        public final Builder includeCertificateDetails(Boolean includeCertificateDetails) {
            this.includeCertificateDetails = includeCertificateDetails;
            return this;
        }

        public final void setIncludeCertificateDetails(Boolean includeCertificateDetails) {
            this.includeCertificateDetails = includeCertificateDetails;
        }

        public final String getCertificateName() {
            return this.certificateName;
        }

        @Override
        public final Builder certificateName(String certificateName) {
            this.certificateName = certificateName;
            return this;
        }

        public final void setCertificateName(String certificateName) {
            this.certificateName = certificateName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCertificatesRequest build() {
            return new GetCertificatesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCertificatesRequest> {
        public Builder certificateStatusesWithStrings(Collection<String> var1);

        public Builder certificateStatusesWithStrings(String ... var1);

        public Builder certificateStatuses(Collection<CertificateStatus> var1);

        public Builder certificateStatuses(CertificateStatus ... var1);

        public Builder includeCertificateDetails(Boolean var1);

        public Builder certificateName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

