/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The password data for the Windows Server-based instance, including the ciphertext and the key pair name.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PasswordData implements SdkPojo, Serializable, ToCopyableBuilder<PasswordData.Builder, PasswordData> {
    private static final SdkField<String> CIPHERTEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ciphertext").getter(getter(PasswordData::ciphertext)).setter(setter(Builder::ciphertext))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ciphertext").build()).build();

    private static final SdkField<String> KEY_PAIR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("keyPairName").getter(getter(PasswordData::keyPairName)).setter(setter(Builder::keyPairName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyPairName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIPHERTEXT_FIELD,
            KEY_PAIR_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ciphertext;

    private final String keyPairName;

    private PasswordData(BuilderImpl builder) {
        this.ciphertext = builder.ciphertext;
        this.keyPairName = builder.keyPairName;
    }

    /**
     * <p>
     * The encrypted password. Ciphertext will be an empty string if access to your new instance is not ready yet. When
     * you create an instance, it can take up to 15 minutes for the instance to be ready.
     * </p>
     * <note>
     * <p>
     * If you use the default key pair (<code>LightsailDefaultKeyPair</code>), the decrypted password will be available
     * in the password field.
     * </p>
     * <p>
     * If you are using a custom key pair, you need to use your own means of decryption.
     * </p>
     * <p>
     * If you change the Administrator password on the instance, Lightsail will continue to return the original
     * ciphertext value. When accessing the instance using RDP, you need to manually enter the Administrator password
     * after changing it from the default.
     * </p>
     * </note>
     * 
     * @return The encrypted password. Ciphertext will be an empty string if access to your new instance is not ready
     *         yet. When you create an instance, it can take up to 15 minutes for the instance to be ready.</p> <note>
     *         <p>
     *         If you use the default key pair (<code>LightsailDefaultKeyPair</code>), the decrypted password will be
     *         available in the password field.
     *         </p>
     *         <p>
     *         If you are using a custom key pair, you need to use your own means of decryption.
     *         </p>
     *         <p>
     *         If you change the Administrator password on the instance, Lightsail will continue to return the original
     *         ciphertext value. When accessing the instance using RDP, you need to manually enter the Administrator
     *         password after changing it from the default.
     *         </p>
     */
    public final String ciphertext() {
        return ciphertext;
    }

    /**
     * <p>
     * The name of the key pair that you used when creating your instance. If no key pair name was specified when
     * creating the instance, Lightsail uses the default key pair (<code>LightsailDefaultKeyPair</code>).
     * </p>
     * <p>
     * If you are using a custom key pair, you need to use your own means of decrypting your password using the
     * <code>ciphertext</code>. Lightsail creates the ciphertext by encrypting your password with the public key part of
     * this key pair.
     * </p>
     * 
     * @return The name of the key pair that you used when creating your instance. If no key pair name was specified
     *         when creating the instance, Lightsail uses the default key pair (<code>LightsailDefaultKeyPair</code>
     *         ).</p>
     *         <p>
     *         If you are using a custom key pair, you need to use your own means of decrypting your password using the
     *         <code>ciphertext</code>. Lightsail creates the ciphertext by encrypting your password with the public key
     *         part of this key pair.
     */
    public final String keyPairName() {
        return keyPairName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ciphertext());
        hashCode = 31 * hashCode + Objects.hashCode(keyPairName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PasswordData)) {
            return false;
        }
        PasswordData other = (PasswordData) obj;
        return Objects.equals(ciphertext(), other.ciphertext()) && Objects.equals(keyPairName(), other.keyPairName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PasswordData").add("Ciphertext", ciphertext()).add("KeyPairName", keyPairName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ciphertext":
            return Optional.ofNullable(clazz.cast(ciphertext()));
        case "keyPairName":
            return Optional.ofNullable(clazz.cast(keyPairName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PasswordData, T> g) {
        return obj -> g.apply((PasswordData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PasswordData> {
        /**
         * <p>
         * The encrypted password. Ciphertext will be an empty string if access to your new instance is not ready yet.
         * When you create an instance, it can take up to 15 minutes for the instance to be ready.
         * </p>
         * <note>
         * <p>
         * If you use the default key pair (<code>LightsailDefaultKeyPair</code>), the decrypted password will be
         * available in the password field.
         * </p>
         * <p>
         * If you are using a custom key pair, you need to use your own means of decryption.
         * </p>
         * <p>
         * If you change the Administrator password on the instance, Lightsail will continue to return the original
         * ciphertext value. When accessing the instance using RDP, you need to manually enter the Administrator
         * password after changing it from the default.
         * </p>
         * </note>
         * 
         * @param ciphertext
         *        The encrypted password. Ciphertext will be an empty string if access to your new instance is not ready
         *        yet. When you create an instance, it can take up to 15 minutes for the instance to be ready.</p>
         *        <note>
         *        <p>
         *        If you use the default key pair (<code>LightsailDefaultKeyPair</code>), the decrypted password will be
         *        available in the password field.
         *        </p>
         *        <p>
         *        If you are using a custom key pair, you need to use your own means of decryption.
         *        </p>
         *        <p>
         *        If you change the Administrator password on the instance, Lightsail will continue to return the
         *        original ciphertext value. When accessing the instance using RDP, you need to manually enter the
         *        Administrator password after changing it from the default.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ciphertext(String ciphertext);

        /**
         * <p>
         * The name of the key pair that you used when creating your instance. If no key pair name was specified when
         * creating the instance, Lightsail uses the default key pair (<code>LightsailDefaultKeyPair</code>).
         * </p>
         * <p>
         * If you are using a custom key pair, you need to use your own means of decrypting your password using the
         * <code>ciphertext</code>. Lightsail creates the ciphertext by encrypting your password with the public key
         * part of this key pair.
         * </p>
         * 
         * @param keyPairName
         *        The name of the key pair that you used when creating your instance. If no key pair name was specified
         *        when creating the instance, Lightsail uses the default key pair (<code>LightsailDefaultKeyPair</code>
         *        ).</p>
         *        <p>
         *        If you are using a custom key pair, you need to use your own means of decrypting your password using
         *        the <code>ciphertext</code>. Lightsail creates the ciphertext by encrypting your password with the
         *        public key part of this key pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPairName(String keyPairName);
    }

    static final class BuilderImpl implements Builder {
        private String ciphertext;

        private String keyPairName;

        private BuilderImpl() {
        }

        private BuilderImpl(PasswordData model) {
            ciphertext(model.ciphertext);
            keyPairName(model.keyPairName);
        }

        public final String getCiphertext() {
            return ciphertext;
        }

        @Override
        public final Builder ciphertext(String ciphertext) {
            this.ciphertext = ciphertext;
            return this;
        }

        public final void setCiphertext(String ciphertext) {
            this.ciphertext = ciphertext;
        }

        public final String getKeyPairName() {
            return keyPairName;
        }

        @Override
        public final Builder keyPairName(String keyPairName) {
            this.keyPairName = keyPairName;
            return this;
        }

        public final void setKeyPairName(String keyPairName) {
            this.keyPairName = keyPairName;
        }

        @Override
        public PasswordData build() {
            return new PasswordData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
