/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the API operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Operation implements SdkPojo, Serializable, ToCopyableBuilder<Operation.Builder, Operation> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(Operation::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceName").getter(getter(Operation::resourceName)).setter(setter(Builder::resourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceName").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(Operation::resourceTypeAsString)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(Operation::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<ResourceLocation> LOCATION_FIELD = SdkField
            .<ResourceLocation> builder(MarshallingType.SDK_POJO).memberName("location").getter(getter(Operation::location))
            .setter(setter(Builder::location)).constructor(ResourceLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()).build();

    private static final SdkField<Boolean> IS_TERMINAL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isTerminal").getter(getter(Operation::isTerminal)).setter(setter(Builder::isTerminal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isTerminal").build()).build();

    private static final SdkField<String> OPERATION_DETAILS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operationDetails").getter(getter(Operation::operationDetails)).setter(setter(Builder::operationDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationDetails").build()).build();

    private static final SdkField<String> OPERATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operationType").getter(getter(Operation::operationTypeAsString)).setter(setter(Builder::operationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationType").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(Operation::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> STATUS_CHANGED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("statusChangedAt").getter(getter(Operation::statusChangedAt)).setter(setter(Builder::statusChangedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusChangedAt").build()).build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorCode").getter(getter(Operation::errorCode)).setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()).build();

    private static final SdkField<String> ERROR_DETAILS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorDetails").getter(getter(Operation::errorDetails)).setter(setter(Builder::errorDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, RESOURCE_NAME_FIELD,
            RESOURCE_TYPE_FIELD, CREATED_AT_FIELD, LOCATION_FIELD, IS_TERMINAL_FIELD, OPERATION_DETAILS_FIELD,
            OPERATION_TYPE_FIELD, STATUS_FIELD, STATUS_CHANGED_AT_FIELD, ERROR_CODE_FIELD, ERROR_DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String resourceName;

    private final String resourceType;

    private final Instant createdAt;

    private final ResourceLocation location;

    private final Boolean isTerminal;

    private final String operationDetails;

    private final String operationType;

    private final String status;

    private final Instant statusChangedAt;

    private final String errorCode;

    private final String errorDetails;

    private Operation(BuilderImpl builder) {
        this.id = builder.id;
        this.resourceName = builder.resourceName;
        this.resourceType = builder.resourceType;
        this.createdAt = builder.createdAt;
        this.location = builder.location;
        this.isTerminal = builder.isTerminal;
        this.operationDetails = builder.operationDetails;
        this.operationType = builder.operationType;
        this.status = builder.status;
        this.statusChangedAt = builder.statusChangedAt;
        this.errorCode = builder.errorCode;
        this.errorDetails = builder.errorDetails;
    }

    /**
     * <p>
     * The ID of the operation.
     * </p>
     * 
     * @return The ID of the operation.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The resource name.
     * </p>
     * 
     * @return The resource name.
     */
    public final String resourceName() {
        return resourceName;
    }

    /**
     * <p>
     * The resource type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The resource type.
     * @see ResourceType
     */
    public final ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The resource type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The resource type.
     * @see ResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * The timestamp when the operation was initialized (e.g., <code>1479816991.349</code>).
     * </p>
     * 
     * @return The timestamp when the operation was initialized (e.g., <code>1479816991.349</code>).
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The AWS Region and Availability Zone.
     * </p>
     * 
     * @return The AWS Region and Availability Zone.
     */
    public final ResourceLocation location() {
        return location;
    }

    /**
     * <p>
     * A Boolean value indicating whether the operation is terminal.
     * </p>
     * 
     * @return A Boolean value indicating whether the operation is terminal.
     */
    public final Boolean isTerminal() {
        return isTerminal;
    }

    /**
     * <p>
     * Details about the operation (e.g., <code>Debian-1GB-Ohio-1</code>).
     * </p>
     * 
     * @return Details about the operation (e.g., <code>Debian-1GB-Ohio-1</code>).
     */
    public final String operationDetails() {
        return operationDetails;
    }

    /**
     * <p>
     * The type of operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operationType}
     * will return {@link OperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operationTypeAsString}.
     * </p>
     * 
     * @return The type of operation.
     * @see OperationType
     */
    public final OperationType operationType() {
        return OperationType.fromValue(operationType);
    }

    /**
     * <p>
     * The type of operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operationType}
     * will return {@link OperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operationTypeAsString}.
     * </p>
     * 
     * @return The type of operation.
     * @see OperationType
     */
    public final String operationTypeAsString() {
        return operationType;
    }

    /**
     * <p>
     * The status of the operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the operation.
     * @see OperationStatus
     */
    public final OperationStatus status() {
        return OperationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the operation.
     * @see OperationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The timestamp when the status was changed (e.g., <code>1479816991.349</code>).
     * </p>
     * 
     * @return The timestamp when the status was changed (e.g., <code>1479816991.349</code>).
     */
    public final Instant statusChangedAt() {
        return statusChangedAt;
    }

    /**
     * <p>
     * The error code.
     * </p>
     * 
     * @return The error code.
     */
    public final String errorCode() {
        return errorCode;
    }

    /**
     * <p>
     * The error details.
     * </p>
     * 
     * @return The error details.
     */
    public final String errorDetails() {
        return errorDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(isTerminal());
        hashCode = 31 * hashCode + Objects.hashCode(operationDetails());
        hashCode = 31 * hashCode + Objects.hashCode(operationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusChangedAt());
        hashCode = 31 * hashCode + Objects.hashCode(errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(errorDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Operation)) {
            return false;
        }
        Operation other = (Operation) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(resourceName(), other.resourceName())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(location(), other.location())
                && Objects.equals(isTerminal(), other.isTerminal())
                && Objects.equals(operationDetails(), other.operationDetails())
                && Objects.equals(operationTypeAsString(), other.operationTypeAsString())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusChangedAt(), other.statusChangedAt()) && Objects.equals(errorCode(), other.errorCode())
                && Objects.equals(errorDetails(), other.errorDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Operation").add("Id", id()).add("ResourceName", resourceName())
                .add("ResourceType", resourceTypeAsString()).add("CreatedAt", createdAt()).add("Location", location())
                .add("IsTerminal", isTerminal()).add("OperationDetails", operationDetails())
                .add("OperationType", operationTypeAsString()).add("Status", statusAsString())
                .add("StatusChangedAt", statusChangedAt()).add("ErrorCode", errorCode()).add("ErrorDetails", errorDetails())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "resourceName":
            return Optional.ofNullable(clazz.cast(resourceName()));
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "location":
            return Optional.ofNullable(clazz.cast(location()));
        case "isTerminal":
            return Optional.ofNullable(clazz.cast(isTerminal()));
        case "operationDetails":
            return Optional.ofNullable(clazz.cast(operationDetails()));
        case "operationType":
            return Optional.ofNullable(clazz.cast(operationTypeAsString()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusChangedAt":
            return Optional.ofNullable(clazz.cast(statusChangedAt()));
        case "errorCode":
            return Optional.ofNullable(clazz.cast(errorCode()));
        case "errorDetails":
            return Optional.ofNullable(clazz.cast(errorDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Operation, T> g) {
        return obj -> g.apply((Operation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Operation> {
        /**
         * <p>
         * The ID of the operation.
         * </p>
         * 
         * @param id
         *        The ID of the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The resource name.
         * </p>
         * 
         * @param resourceName
         *        The resource name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceName(String resourceName);

        /**
         * <p>
         * The resource type.
         * </p>
         * 
         * @param resourceType
         *        The resource type.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The resource type.
         * </p>
         * 
         * @param resourceType
         *        The resource type.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * The timestamp when the operation was initialized (e.g., <code>1479816991.349</code>).
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the operation was initialized (e.g., <code>1479816991.349</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The AWS Region and Availability Zone.
         * </p>
         * 
         * @param location
         *        The AWS Region and Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(ResourceLocation location);

        /**
         * <p>
         * The AWS Region and Availability Zone.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceLocation.Builder} avoiding the need to
         * create one manually via {@link ResourceLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #location(ResourceLocation)}.
         * 
         * @param location
         *        a consumer that will call methods on {@link ResourceLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #location(ResourceLocation)
         */
        default Builder location(Consumer<ResourceLocation.Builder> location) {
            return location(ResourceLocation.builder().applyMutation(location).build());
        }

        /**
         * <p>
         * A Boolean value indicating whether the operation is terminal.
         * </p>
         * 
         * @param isTerminal
         *        A Boolean value indicating whether the operation is terminal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTerminal(Boolean isTerminal);

        /**
         * <p>
         * Details about the operation (e.g., <code>Debian-1GB-Ohio-1</code>).
         * </p>
         * 
         * @param operationDetails
         *        Details about the operation (e.g., <code>Debian-1GB-Ohio-1</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationDetails(String operationDetails);

        /**
         * <p>
         * The type of operation.
         * </p>
         * 
         * @param operationType
         *        The type of operation.
         * @see OperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationType
         */
        Builder operationType(String operationType);

        /**
         * <p>
         * The type of operation.
         * </p>
         * 
         * @param operationType
         *        The type of operation.
         * @see OperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationType
         */
        Builder operationType(OperationType operationType);

        /**
         * <p>
         * The status of the operation.
         * </p>
         * 
         * @param status
         *        The status of the operation.
         * @see OperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the operation.
         * </p>
         * 
         * @param status
         *        The status of the operation.
         * @see OperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationStatus
         */
        Builder status(OperationStatus status);

        /**
         * <p>
         * The timestamp when the status was changed (e.g., <code>1479816991.349</code>).
         * </p>
         * 
         * @param statusChangedAt
         *        The timestamp when the status was changed (e.g., <code>1479816991.349</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusChangedAt(Instant statusChangedAt);

        /**
         * <p>
         * The error code.
         * </p>
         * 
         * @param errorCode
         *        The error code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The error details.
         * </p>
         * 
         * @param errorDetails
         *        The error details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorDetails(String errorDetails);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String resourceName;

        private String resourceType;

        private Instant createdAt;

        private ResourceLocation location;

        private Boolean isTerminal;

        private String operationDetails;

        private String operationType;

        private String status;

        private Instant statusChangedAt;

        private String errorCode;

        private String errorDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(Operation model) {
            id(model.id);
            resourceName(model.resourceName);
            resourceType(model.resourceType);
            createdAt(model.createdAt);
            location(model.location);
            isTerminal(model.isTerminal);
            operationDetails(model.operationDetails);
            operationType(model.operationType);
            status(model.status);
            statusChangedAt(model.statusChangedAt);
            errorCode(model.errorCode);
            errorDetails(model.errorDetails);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getResourceName() {
            return resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final ResourceLocation.Builder getLocation() {
            return location != null ? location.toBuilder() : null;
        }

        @Override
        public final Builder location(ResourceLocation location) {
            this.location = location;
            return this;
        }

        public final void setLocation(ResourceLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        public final Boolean getIsTerminal() {
            return isTerminal;
        }

        @Override
        public final Builder isTerminal(Boolean isTerminal) {
            this.isTerminal = isTerminal;
            return this;
        }

        public final void setIsTerminal(Boolean isTerminal) {
            this.isTerminal = isTerminal;
        }

        public final String getOperationDetails() {
            return operationDetails;
        }

        @Override
        public final Builder operationDetails(String operationDetails) {
            this.operationDetails = operationDetails;
            return this;
        }

        public final void setOperationDetails(String operationDetails) {
            this.operationDetails = operationDetails;
        }

        public final String getOperationType() {
            return operationType;
        }

        @Override
        public final Builder operationType(String operationType) {
            this.operationType = operationType;
            return this;
        }

        @Override
        public final Builder operationType(OperationType operationType) {
            this.operationType(operationType == null ? null : operationType.toString());
            return this;
        }

        public final void setOperationType(String operationType) {
            this.operationType = operationType;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OperationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getStatusChangedAt() {
            return statusChangedAt;
        }

        @Override
        public final Builder statusChangedAt(Instant statusChangedAt) {
            this.statusChangedAt = statusChangedAt;
            return this;
        }

        public final void setStatusChangedAt(Instant statusChangedAt) {
            this.statusChangedAt = statusChangedAt;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getErrorDetails() {
            return errorDetails;
        }

        @Override
        public final Builder errorDetails(String errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public final void setErrorDetails(String errorDetails) {
            this.errorDetails = errorDetails;
        }

        @Override
        public Operation build() {
            return new Operation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
