/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetInstancePortStatesResponse extends LightsailResponse implements
        ToCopyableBuilder<GetInstancePortStatesResponse.Builder, GetInstancePortStatesResponse> {
    private static final SdkField<List<InstancePortState>> PORT_STATES_FIELD = SdkField
            .<List<InstancePortState>> builder(MarshallingType.LIST)
            .memberName("portStates")
            .getter(getter(GetInstancePortStatesResponse::portStates))
            .setter(setter(Builder::portStates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portStates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InstancePortState> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstancePortState::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORT_STATES_FIELD));

    private final List<InstancePortState> portStates;

    private GetInstancePortStatesResponse(BuilderImpl builder) {
        super(builder);
        this.portStates = builder.portStates;
    }

    /**
     * Returns true if the PortStates property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasPortStates() {
        return portStates != null && !(portStates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that describe the firewall port states for the specified instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPortStates()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects that describe the firewall port states for the specified instance.
     */
    public final List<InstancePortState> portStates() {
        return portStates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPortStates() ? portStates() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInstancePortStatesResponse)) {
            return false;
        }
        GetInstancePortStatesResponse other = (GetInstancePortStatesResponse) obj;
        return hasPortStates() == other.hasPortStates() && Objects.equals(portStates(), other.portStates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetInstancePortStatesResponse").add("PortStates", hasPortStates() ? portStates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "portStates":
            return Optional.ofNullable(clazz.cast(portStates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetInstancePortStatesResponse, T> g) {
        return obj -> g.apply((GetInstancePortStatesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetInstancePortStatesResponse> {
        /**
         * <p>
         * An array of objects that describe the firewall port states for the specified instance.
         * </p>
         * 
         * @param portStates
         *        An array of objects that describe the firewall port states for the specified instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portStates(Collection<InstancePortState> portStates);

        /**
         * <p>
         * An array of objects that describe the firewall port states for the specified instance.
         * </p>
         * 
         * @param portStates
         *        An array of objects that describe the firewall port states for the specified instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portStates(InstancePortState... portStates);

        /**
         * <p>
         * An array of objects that describe the firewall port states for the specified instance.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InstancePortState>.Builder} avoiding the
         * need to create one manually via {@link List<InstancePortState>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InstancePortState>.Builder#build()} is called immediately
         * and its result is passed to {@link #portStates(List<InstancePortState>)}.
         * 
         * @param portStates
         *        a consumer that will call methods on {@link List<InstancePortState>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #portStates(List<InstancePortState>)
         */
        Builder portStates(Consumer<InstancePortState.Builder>... portStates);
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private List<InstancePortState> portStates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetInstancePortStatesResponse model) {
            super(model);
            portStates(model.portStates);
        }

        public final Collection<InstancePortState.Builder> getPortStates() {
            if (portStates instanceof SdkAutoConstructList) {
                return null;
            }
            return portStates != null ? portStates.stream().map(InstancePortState::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder portStates(Collection<InstancePortState> portStates) {
            this.portStates = InstancePortStateListCopier.copy(portStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portStates(InstancePortState... portStates) {
            portStates(Arrays.asList(portStates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portStates(Consumer<InstancePortState.Builder>... portStates) {
            portStates(Stream.of(portStates).map(c -> InstancePortState.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPortStates(Collection<InstancePortState.BuilderImpl> portStates) {
            this.portStates = InstancePortStateListCopier.copyFromBuilder(portStates);
        }

        @Override
        public GetInstancePortStatesResponse build() {
            return new GetInstancePortStatesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
