/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteAutoSnapshotRequest extends LightsailRequest implements
        ToCopyableBuilder<DeleteAutoSnapshotRequest.Builder, DeleteAutoSnapshotRequest> {
    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceName").getter(getter(DeleteAutoSnapshotRequest::resourceName))
            .setter(setter(Builder::resourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceName").build()).build();

    private static final SdkField<String> DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("date")
            .getter(getter(DeleteAutoSnapshotRequest::date)).setter(setter(Builder::date))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("date").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_NAME_FIELD,
            DATE_FIELD));

    private final String resourceName;

    private final String date;

    private DeleteAutoSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.resourceName = builder.resourceName;
        this.date = builder.date;
    }

    /**
     * <p>
     * The name of the source instance or disk from which to delete the automatic snapshot.
     * </p>
     * 
     * @return The name of the source instance or disk from which to delete the automatic snapshot.
     */
    public final String resourceName() {
        return resourceName;
    }

    /**
     * <p>
     * The date of the automatic snapshot to delete in <code>YYYY-MM-DD</code> format. Use the
     * <code>get auto snapshots</code> operation to get the available automatic snapshots for a resource.
     * </p>
     * 
     * @return The date of the automatic snapshot to delete in <code>YYYY-MM-DD</code> format. Use the
     *         <code>get auto snapshots</code> operation to get the available automatic snapshots for a resource.
     */
    public final String date() {
        return date;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(date());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAutoSnapshotRequest)) {
            return false;
        }
        DeleteAutoSnapshotRequest other = (DeleteAutoSnapshotRequest) obj;
        return Objects.equals(resourceName(), other.resourceName()) && Objects.equals(date(), other.date());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteAutoSnapshotRequest").add("ResourceName", resourceName()).add("Date", date()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceName":
            return Optional.ofNullable(clazz.cast(resourceName()));
        case "date":
            return Optional.ofNullable(clazz.cast(date()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteAutoSnapshotRequest, T> g) {
        return obj -> g.apply((DeleteAutoSnapshotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteAutoSnapshotRequest> {
        /**
         * <p>
         * The name of the source instance or disk from which to delete the automatic snapshot.
         * </p>
         * 
         * @param resourceName
         *        The name of the source instance or disk from which to delete the automatic snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceName(String resourceName);

        /**
         * <p>
         * The date of the automatic snapshot to delete in <code>YYYY-MM-DD</code> format. Use the
         * <code>get auto snapshots</code> operation to get the available automatic snapshots for a resource.
         * </p>
         * 
         * @param date
         *        The date of the automatic snapshot to delete in <code>YYYY-MM-DD</code> format. Use the
         *        <code>get auto snapshots</code> operation to get the available automatic snapshots for a resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder date(String date);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String resourceName;

        private String date;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAutoSnapshotRequest model) {
            super(model);
            resourceName(model.resourceName);
            date(model.date);
        }

        public final String getResourceName() {
            return resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        public final String getDate() {
            return date;
        }

        @Override
        public final Builder date(String date) {
            this.date = date;
            return this;
        }

        public final void setDate(String date) {
            this.date = date;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteAutoSnapshotRequest build() {
            return new DeleteAutoSnapshotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
