/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContainerImage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContainerImage> {
    private static final SdkField<String> IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("image").getter(ContainerImage.getter(ContainerImage::image)).setter(ContainerImage.setter(Builder::image)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("image").build()}).build();
    private static final SdkField<String> DIGEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("digest").getter(ContainerImage.getter(ContainerImage::digest)).setter(ContainerImage.setter(Builder::digest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("digest").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(ContainerImage.getter(ContainerImage::createdAt)).setter(ContainerImage.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_FIELD, DIGEST_FIELD, CREATED_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String image;
    private final String digest;
    private final Instant createdAt;

    private ContainerImage(BuilderImpl builder) {
        this.image = builder.image;
        this.digest = builder.digest;
        this.createdAt = builder.createdAt;
    }

    public String image() {
        return this.image;
    }

    public String digest() {
        return this.digest;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        hashCode = 31 * hashCode + Objects.hashCode(this.digest());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerImage)) {
            return false;
        }
        ContainerImage other = (ContainerImage)obj;
        return Objects.equals(this.image(), other.image()) && Objects.equals(this.digest(), other.digest()) && Objects.equals(this.createdAt(), other.createdAt());
    }

    public String toString() {
        return ToString.builder((String)"ContainerImage").add("Image", (Object)this.image()).add("Digest", (Object)this.digest()).add("CreatedAt", (Object)this.createdAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "image": {
                return Optional.ofNullable(clazz.cast(this.image()));
            }
            case "digest": {
                return Optional.ofNullable(clazz.cast(this.digest()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContainerImage, T> g) {
        return obj -> g.apply((ContainerImage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String image;
        private String digest;
        private Instant createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerImage model) {
            this.image(model.image);
            this.digest(model.digest);
            this.createdAt(model.createdAt);
        }

        public final String getImage() {
            return this.image;
        }

        @Override
        public final Builder image(String image) {
            this.image = image;
            return this;
        }

        public final void setImage(String image) {
            this.image = image;
        }

        public final String getDigest() {
            return this.digest;
        }

        @Override
        public final Builder digest(String digest) {
            this.digest = digest;
            return this;
        }

        public final void setDigest(String digest) {
            this.digest = digest;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public ContainerImage build() {
            return new ContainerImage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContainerImage> {
        public Builder image(String var1);

        public Builder digest(String var1);

        public Builder createdAt(Instant var1);
    }
}

