/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContainerServiceHealthCheckConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContainerServiceHealthCheckConfig> {
    private static final SdkField<Integer> HEALTHY_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("healthyThreshold").getter(ContainerServiceHealthCheckConfig.getter(ContainerServiceHealthCheckConfig::healthyThreshold)).setter(ContainerServiceHealthCheckConfig.setter(Builder::healthyThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthyThreshold").build()}).build();
    private static final SdkField<Integer> UNHEALTHY_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("unhealthyThreshold").getter(ContainerServiceHealthCheckConfig.getter(ContainerServiceHealthCheckConfig::unhealthyThreshold)).setter(ContainerServiceHealthCheckConfig.setter(Builder::unhealthyThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unhealthyThreshold").build()}).build();
    private static final SdkField<Integer> TIMEOUT_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("timeoutSeconds").getter(ContainerServiceHealthCheckConfig.getter(ContainerServiceHealthCheckConfig::timeoutSeconds)).setter(ContainerServiceHealthCheckConfig.setter(Builder::timeoutSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutSeconds").build()}).build();
    private static final SdkField<Integer> INTERVAL_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("intervalSeconds").getter(ContainerServiceHealthCheckConfig.getter(ContainerServiceHealthCheckConfig::intervalSeconds)).setter(ContainerServiceHealthCheckConfig.setter(Builder::intervalSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intervalSeconds").build()}).build();
    private static final SdkField<String> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("path").getter(ContainerServiceHealthCheckConfig.getter(ContainerServiceHealthCheckConfig::path)).setter(ContainerServiceHealthCheckConfig.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("path").build()}).build();
    private static final SdkField<String> SUCCESS_CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("successCodes").getter(ContainerServiceHealthCheckConfig.getter(ContainerServiceHealthCheckConfig::successCodes)).setter(ContainerServiceHealthCheckConfig.setter(Builder::successCodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("successCodes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEALTHY_THRESHOLD_FIELD, UNHEALTHY_THRESHOLD_FIELD, TIMEOUT_SECONDS_FIELD, INTERVAL_SECONDS_FIELD, PATH_FIELD, SUCCESS_CODES_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer healthyThreshold;
    private final Integer unhealthyThreshold;
    private final Integer timeoutSeconds;
    private final Integer intervalSeconds;
    private final String path;
    private final String successCodes;

    private ContainerServiceHealthCheckConfig(BuilderImpl builder) {
        this.healthyThreshold = builder.healthyThreshold;
        this.unhealthyThreshold = builder.unhealthyThreshold;
        this.timeoutSeconds = builder.timeoutSeconds;
        this.intervalSeconds = builder.intervalSeconds;
        this.path = builder.path;
        this.successCodes = builder.successCodes;
    }

    public Integer healthyThreshold() {
        return this.healthyThreshold;
    }

    public Integer unhealthyThreshold() {
        return this.unhealthyThreshold;
    }

    public Integer timeoutSeconds() {
        return this.timeoutSeconds;
    }

    public Integer intervalSeconds() {
        return this.intervalSeconds;
    }

    public String path() {
        return this.path;
    }

    public String successCodes() {
        return this.successCodes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.healthyThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.unhealthyThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.intervalSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.successCodes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerServiceHealthCheckConfig)) {
            return false;
        }
        ContainerServiceHealthCheckConfig other = (ContainerServiceHealthCheckConfig)obj;
        return Objects.equals(this.healthyThreshold(), other.healthyThreshold()) && Objects.equals(this.unhealthyThreshold(), other.unhealthyThreshold()) && Objects.equals(this.timeoutSeconds(), other.timeoutSeconds()) && Objects.equals(this.intervalSeconds(), other.intervalSeconds()) && Objects.equals(this.path(), other.path()) && Objects.equals(this.successCodes(), other.successCodes());
    }

    public String toString() {
        return ToString.builder((String)"ContainerServiceHealthCheckConfig").add("HealthyThreshold", (Object)this.healthyThreshold()).add("UnhealthyThreshold", (Object)this.unhealthyThreshold()).add("TimeoutSeconds", (Object)this.timeoutSeconds()).add("IntervalSeconds", (Object)this.intervalSeconds()).add("Path", (Object)this.path()).add("SuccessCodes", (Object)this.successCodes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "healthyThreshold": {
                return Optional.ofNullable(clazz.cast(this.healthyThreshold()));
            }
            case "unhealthyThreshold": {
                return Optional.ofNullable(clazz.cast(this.unhealthyThreshold()));
            }
            case "timeoutSeconds": {
                return Optional.ofNullable(clazz.cast(this.timeoutSeconds()));
            }
            case "intervalSeconds": {
                return Optional.ofNullable(clazz.cast(this.intervalSeconds()));
            }
            case "path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "successCodes": {
                return Optional.ofNullable(clazz.cast(this.successCodes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContainerServiceHealthCheckConfig, T> g) {
        return obj -> g.apply((ContainerServiceHealthCheckConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer healthyThreshold;
        private Integer unhealthyThreshold;
        private Integer timeoutSeconds;
        private Integer intervalSeconds;
        private String path;
        private String successCodes;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerServiceHealthCheckConfig model) {
            this.healthyThreshold(model.healthyThreshold);
            this.unhealthyThreshold(model.unhealthyThreshold);
            this.timeoutSeconds(model.timeoutSeconds);
            this.intervalSeconds(model.intervalSeconds);
            this.path(model.path);
            this.successCodes(model.successCodes);
        }

        public final Integer getHealthyThreshold() {
            return this.healthyThreshold;
        }

        @Override
        public final Builder healthyThreshold(Integer healthyThreshold) {
            this.healthyThreshold = healthyThreshold;
            return this;
        }

        public final void setHealthyThreshold(Integer healthyThreshold) {
            this.healthyThreshold = healthyThreshold;
        }

        public final Integer getUnhealthyThreshold() {
            return this.unhealthyThreshold;
        }

        @Override
        public final Builder unhealthyThreshold(Integer unhealthyThreshold) {
            this.unhealthyThreshold = unhealthyThreshold;
            return this;
        }

        public final void setUnhealthyThreshold(Integer unhealthyThreshold) {
            this.unhealthyThreshold = unhealthyThreshold;
        }

        public final Integer getTimeoutSeconds() {
            return this.timeoutSeconds;
        }

        @Override
        public final Builder timeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public final void setTimeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
        }

        public final Integer getIntervalSeconds() {
            return this.intervalSeconds;
        }

        @Override
        public final Builder intervalSeconds(Integer intervalSeconds) {
            this.intervalSeconds = intervalSeconds;
            return this;
        }

        public final void setIntervalSeconds(Integer intervalSeconds) {
            this.intervalSeconds = intervalSeconds;
        }

        public final String getPath() {
            return this.path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final String getSuccessCodes() {
            return this.successCodes;
        }

        @Override
        public final Builder successCodes(String successCodes) {
            this.successCodes = successCodes;
            return this;
        }

        public final void setSuccessCodes(String successCodes) {
            this.successCodes = successCodes;
        }

        public ContainerServiceHealthCheckConfig build() {
            return new ContainerServiceHealthCheckConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContainerServiceHealthCheckConfig> {
        public Builder healthyThreshold(Integer var1);

        public Builder unhealthyThreshold(Integer var1);

        public Builder timeoutSeconds(Integer var1);

        public Builder intervalSeconds(Integer var1);

        public Builder path(String var1);

        public Builder successCodes(String var1);
    }
}

