/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.CacheBehavior;
import software.amazon.awssdk.services.lightsail.model.CacheBehaviorListCopier;
import software.amazon.awssdk.services.lightsail.model.CacheBehaviorPerPath;
import software.amazon.awssdk.services.lightsail.model.CacheSettings;
import software.amazon.awssdk.services.lightsail.model.Origin;
import software.amazon.awssdk.services.lightsail.model.ResourceLocation;
import software.amazon.awssdk.services.lightsail.model.ResourceType;
import software.amazon.awssdk.services.lightsail.model.StringListCopier;
import software.amazon.awssdk.services.lightsail.model.Tag;
import software.amazon.awssdk.services.lightsail.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LightsailDistribution
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LightsailDistribution> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LightsailDistribution.getter(LightsailDistribution::name)).setter(LightsailDistribution.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LightsailDistribution.getter(LightsailDistribution::arn)).setter(LightsailDistribution.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> SUPPORT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LightsailDistribution.getter(LightsailDistribution::supportCode)).setter(LightsailDistribution.setter(Builder::supportCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportCode").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(LightsailDistribution.getter(LightsailDistribution::createdAt)).setter(LightsailDistribution.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<ResourceLocation> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(LightsailDistribution.getter(LightsailDistribution::location)).setter(LightsailDistribution.setter(Builder::location)).constructor(ResourceLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LightsailDistribution.getter(LightsailDistribution::resourceTypeAsString)).setter(LightsailDistribution.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<List<String>> ALTERNATIVE_DOMAIN_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(LightsailDistribution.getter(LightsailDistribution::alternativeDomainNames)).setter(LightsailDistribution.setter(Builder::alternativeDomainNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alternativeDomainNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LightsailDistribution.getter(LightsailDistribution::status)).setter(LightsailDistribution.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Boolean> IS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(LightsailDistribution.getter(LightsailDistribution::isEnabled)).setter(LightsailDistribution.setter(Builder::isEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isEnabled").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LightsailDistribution.getter(LightsailDistribution::domainName)).setter(LightsailDistribution.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()}).build();
    private static final SdkField<String> BUNDLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LightsailDistribution.getter(LightsailDistribution::bundleId)).setter(LightsailDistribution.setter(Builder::bundleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bundleId").build()}).build();
    private static final SdkField<String> CERTIFICATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LightsailDistribution.getter(LightsailDistribution::certificateName)).setter(LightsailDistribution.setter(Builder::certificateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateName").build()}).build();
    private static final SdkField<Origin> ORIGIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(LightsailDistribution.getter(LightsailDistribution::origin)).setter(LightsailDistribution.setter(Builder::origin)).constructor(Origin::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("origin").build()}).build();
    private static final SdkField<String> ORIGIN_PUBLIC_DNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LightsailDistribution.getter(LightsailDistribution::originPublicDNS)).setter(LightsailDistribution.setter(Builder::originPublicDNS)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originPublicDNS").build()}).build();
    private static final SdkField<CacheBehavior> DEFAULT_CACHE_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(LightsailDistribution.getter(LightsailDistribution::defaultCacheBehavior)).setter(LightsailDistribution.setter(Builder::defaultCacheBehavior)).constructor(CacheBehavior::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultCacheBehavior").build()}).build();
    private static final SdkField<CacheSettings> CACHE_BEHAVIOR_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(LightsailDistribution.getter(LightsailDistribution::cacheBehaviorSettings)).setter(LightsailDistribution.setter(Builder::cacheBehaviorSettings)).constructor(CacheSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheBehaviorSettings").build()}).build();
    private static final SdkField<List<CacheBehaviorPerPath>> CACHE_BEHAVIORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(LightsailDistribution.getter(LightsailDistribution::cacheBehaviors)).setter(LightsailDistribution.setter(Builder::cacheBehaviors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheBehaviors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CacheBehaviorPerPath::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ABLE_TO_UPDATE_BUNDLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(LightsailDistribution.getter(LightsailDistribution::ableToUpdateBundle)).setter(LightsailDistribution.setter(Builder::ableToUpdateBundle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ableToUpdateBundle").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(LightsailDistribution.getter(LightsailDistribution::tags)).setter(LightsailDistribution.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD, SUPPORT_CODE_FIELD, CREATED_AT_FIELD, LOCATION_FIELD, RESOURCE_TYPE_FIELD, ALTERNATIVE_DOMAIN_NAMES_FIELD, STATUS_FIELD, IS_ENABLED_FIELD, DOMAIN_NAME_FIELD, BUNDLE_ID_FIELD, CERTIFICATE_NAME_FIELD, ORIGIN_FIELD, ORIGIN_PUBLIC_DNS_FIELD, DEFAULT_CACHE_BEHAVIOR_FIELD, CACHE_BEHAVIOR_SETTINGS_FIELD, CACHE_BEHAVIORS_FIELD, ABLE_TO_UPDATE_BUNDLE_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String arn;
    private final String supportCode;
    private final Instant createdAt;
    private final ResourceLocation location;
    private final String resourceType;
    private final List<String> alternativeDomainNames;
    private final String status;
    private final Boolean isEnabled;
    private final String domainName;
    private final String bundleId;
    private final String certificateName;
    private final Origin origin;
    private final String originPublicDNS;
    private final CacheBehavior defaultCacheBehavior;
    private final CacheSettings cacheBehaviorSettings;
    private final List<CacheBehaviorPerPath> cacheBehaviors;
    private final Boolean ableToUpdateBundle;
    private final List<Tag> tags;

    private LightsailDistribution(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.supportCode = builder.supportCode;
        this.createdAt = builder.createdAt;
        this.location = builder.location;
        this.resourceType = builder.resourceType;
        this.alternativeDomainNames = builder.alternativeDomainNames;
        this.status = builder.status;
        this.isEnabled = builder.isEnabled;
        this.domainName = builder.domainName;
        this.bundleId = builder.bundleId;
        this.certificateName = builder.certificateName;
        this.origin = builder.origin;
        this.originPublicDNS = builder.originPublicDNS;
        this.defaultCacheBehavior = builder.defaultCacheBehavior;
        this.cacheBehaviorSettings = builder.cacheBehaviorSettings;
        this.cacheBehaviors = builder.cacheBehaviors;
        this.ableToUpdateBundle = builder.ableToUpdateBundle;
        this.tags = builder.tags;
    }

    public String name() {
        return this.name;
    }

    public String arn() {
        return this.arn;
    }

    public String supportCode() {
        return this.supportCode;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public ResourceLocation location() {
        return this.location;
    }

    public ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public String resourceTypeAsString() {
        return this.resourceType;
    }

    public boolean hasAlternativeDomainNames() {
        return this.alternativeDomainNames != null && !(this.alternativeDomainNames instanceof SdkAutoConstructList);
    }

    public List<String> alternativeDomainNames() {
        return this.alternativeDomainNames;
    }

    public String status() {
        return this.status;
    }

    public Boolean isEnabled() {
        return this.isEnabled;
    }

    public String domainName() {
        return this.domainName;
    }

    public String bundleId() {
        return this.bundleId;
    }

    public String certificateName() {
        return this.certificateName;
    }

    public Origin origin() {
        return this.origin;
    }

    public String originPublicDNS() {
        return this.originPublicDNS;
    }

    public CacheBehavior defaultCacheBehavior() {
        return this.defaultCacheBehavior;
    }

    public CacheSettings cacheBehaviorSettings() {
        return this.cacheBehaviorSettings;
    }

    public boolean hasCacheBehaviors() {
        return this.cacheBehaviors != null && !(this.cacheBehaviors instanceof SdkAutoConstructList);
    }

    public List<CacheBehaviorPerPath> cacheBehaviors() {
        return this.cacheBehaviors;
    }

    public Boolean ableToUpdateBundle() {
        return this.ableToUpdateBundle;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.alternativeDomainNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.isEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.bundleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.origin());
        hashCode = 31 * hashCode + Objects.hashCode(this.originPublicDNS());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultCacheBehavior());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheBehaviorSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheBehaviors());
        hashCode = 31 * hashCode + Objects.hashCode(this.ableToUpdateBundle());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LightsailDistribution)) {
            return false;
        }
        LightsailDistribution other = (LightsailDistribution)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.supportCode(), other.supportCode()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.alternativeDomainNames(), other.alternativeDomainNames()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.isEnabled(), other.isEnabled()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.bundleId(), other.bundleId()) && Objects.equals(this.certificateName(), other.certificateName()) && Objects.equals(this.origin(), other.origin()) && Objects.equals(this.originPublicDNS(), other.originPublicDNS()) && Objects.equals(this.defaultCacheBehavior(), other.defaultCacheBehavior()) && Objects.equals(this.cacheBehaviorSettings(), other.cacheBehaviorSettings()) && Objects.equals(this.cacheBehaviors(), other.cacheBehaviors()) && Objects.equals(this.ableToUpdateBundle(), other.ableToUpdateBundle()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"LightsailDistribution").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("SupportCode", (Object)this.supportCode()).add("CreatedAt", (Object)this.createdAt()).add("Location", (Object)this.location()).add("ResourceType", (Object)this.resourceTypeAsString()).add("AlternativeDomainNames", this.alternativeDomainNames()).add("Status", (Object)this.status()).add("IsEnabled", (Object)this.isEnabled()).add("DomainName", (Object)this.domainName()).add("BundleId", (Object)this.bundleId()).add("CertificateName", (Object)this.certificateName()).add("Origin", (Object)this.origin()).add("OriginPublicDNS", (Object)this.originPublicDNS()).add("DefaultCacheBehavior", (Object)this.defaultCacheBehavior()).add("CacheBehaviorSettings", (Object)this.cacheBehaviorSettings()).add("CacheBehaviors", this.cacheBehaviors()).add("AbleToUpdateBundle", (Object)this.ableToUpdateBundle()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "supportCode": {
                return Optional.ofNullable(clazz.cast(this.supportCode()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "alternativeDomainNames": {
                return Optional.ofNullable(clazz.cast(this.alternativeDomainNames()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "isEnabled": {
                return Optional.ofNullable(clazz.cast(this.isEnabled()));
            }
            case "domainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "bundleId": {
                return Optional.ofNullable(clazz.cast(this.bundleId()));
            }
            case "certificateName": {
                return Optional.ofNullable(clazz.cast(this.certificateName()));
            }
            case "origin": {
                return Optional.ofNullable(clazz.cast(this.origin()));
            }
            case "originPublicDNS": {
                return Optional.ofNullable(clazz.cast(this.originPublicDNS()));
            }
            case "defaultCacheBehavior": {
                return Optional.ofNullable(clazz.cast(this.defaultCacheBehavior()));
            }
            case "cacheBehaviorSettings": {
                return Optional.ofNullable(clazz.cast(this.cacheBehaviorSettings()));
            }
            case "cacheBehaviors": {
                return Optional.ofNullable(clazz.cast(this.cacheBehaviors()));
            }
            case "ableToUpdateBundle": {
                return Optional.ofNullable(clazz.cast(this.ableToUpdateBundle()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LightsailDistribution, T> g) {
        return obj -> g.apply((LightsailDistribution)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private String supportCode;
        private Instant createdAt;
        private ResourceLocation location;
        private String resourceType;
        private List<String> alternativeDomainNames = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private Boolean isEnabled;
        private String domainName;
        private String bundleId;
        private String certificateName;
        private Origin origin;
        private String originPublicDNS;
        private CacheBehavior defaultCacheBehavior;
        private CacheSettings cacheBehaviorSettings;
        private List<CacheBehaviorPerPath> cacheBehaviors = DefaultSdkAutoConstructList.getInstance();
        private Boolean ableToUpdateBundle;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LightsailDistribution model) {
            this.name(model.name);
            this.arn(model.arn);
            this.supportCode(model.supportCode);
            this.createdAt(model.createdAt);
            this.location(model.location);
            this.resourceType(model.resourceType);
            this.alternativeDomainNames(model.alternativeDomainNames);
            this.status(model.status);
            this.isEnabled(model.isEnabled);
            this.domainName(model.domainName);
            this.bundleId(model.bundleId);
            this.certificateName(model.certificateName);
            this.origin(model.origin);
            this.originPublicDNS(model.originPublicDNS);
            this.defaultCacheBehavior(model.defaultCacheBehavior);
            this.cacheBehaviorSettings(model.cacheBehaviorSettings);
            this.cacheBehaviors(model.cacheBehaviors);
            this.ableToUpdateBundle(model.ableToUpdateBundle);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getSupportCode() {
            return this.supportCode;
        }

        @Override
        public final Builder supportCode(String supportCode) {
            this.supportCode = supportCode;
            return this;
        }

        public final void setSupportCode(String supportCode) {
            this.supportCode = supportCode;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final ResourceLocation.Builder getLocation() {
            return this.location != null ? this.location.toBuilder() : null;
        }

        @Override
        public final Builder location(ResourceLocation location) {
            this.location = location;
            return this;
        }

        public final void setLocation(ResourceLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Collection<String> getAlternativeDomainNames() {
            return this.alternativeDomainNames;
        }

        @Override
        public final Builder alternativeDomainNames(Collection<String> alternativeDomainNames) {
            this.alternativeDomainNames = StringListCopier.copy(alternativeDomainNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alternativeDomainNames(String ... alternativeDomainNames) {
            this.alternativeDomainNames(Arrays.asList(alternativeDomainNames));
            return this;
        }

        public final void setAlternativeDomainNames(Collection<String> alternativeDomainNames) {
            this.alternativeDomainNames = StringListCopier.copy(alternativeDomainNames);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Boolean getIsEnabled() {
            return this.isEnabled;
        }

        @Override
        public final Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            return this;
        }

        public final void setIsEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getBundleId() {
            return this.bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        public final String getCertificateName() {
            return this.certificateName;
        }

        @Override
        public final Builder certificateName(String certificateName) {
            this.certificateName = certificateName;
            return this;
        }

        public final void setCertificateName(String certificateName) {
            this.certificateName = certificateName;
        }

        public final Origin.Builder getOrigin() {
            return this.origin != null ? this.origin.toBuilder() : null;
        }

        @Override
        public final Builder origin(Origin origin) {
            this.origin = origin;
            return this;
        }

        public final void setOrigin(Origin.BuilderImpl origin) {
            this.origin = origin != null ? origin.build() : null;
        }

        public final String getOriginPublicDNS() {
            return this.originPublicDNS;
        }

        @Override
        public final Builder originPublicDNS(String originPublicDNS) {
            this.originPublicDNS = originPublicDNS;
            return this;
        }

        public final void setOriginPublicDNS(String originPublicDNS) {
            this.originPublicDNS = originPublicDNS;
        }

        public final CacheBehavior.Builder getDefaultCacheBehavior() {
            return this.defaultCacheBehavior != null ? this.defaultCacheBehavior.toBuilder() : null;
        }

        @Override
        public final Builder defaultCacheBehavior(CacheBehavior defaultCacheBehavior) {
            this.defaultCacheBehavior = defaultCacheBehavior;
            return this;
        }

        public final void setDefaultCacheBehavior(CacheBehavior.BuilderImpl defaultCacheBehavior) {
            this.defaultCacheBehavior = defaultCacheBehavior != null ? defaultCacheBehavior.build() : null;
        }

        public final CacheSettings.Builder getCacheBehaviorSettings() {
            return this.cacheBehaviorSettings != null ? this.cacheBehaviorSettings.toBuilder() : null;
        }

        @Override
        public final Builder cacheBehaviorSettings(CacheSettings cacheBehaviorSettings) {
            this.cacheBehaviorSettings = cacheBehaviorSettings;
            return this;
        }

        public final void setCacheBehaviorSettings(CacheSettings.BuilderImpl cacheBehaviorSettings) {
            this.cacheBehaviorSettings = cacheBehaviorSettings != null ? cacheBehaviorSettings.build() : null;
        }

        public final Collection<CacheBehaviorPerPath.Builder> getCacheBehaviors() {
            return this.cacheBehaviors != null ? (Collection)this.cacheBehaviors.stream().map(CacheBehaviorPerPath::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder cacheBehaviors(Collection<CacheBehaviorPerPath> cacheBehaviors) {
            this.cacheBehaviors = CacheBehaviorListCopier.copy(cacheBehaviors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheBehaviors(CacheBehaviorPerPath ... cacheBehaviors) {
            this.cacheBehaviors(Arrays.asList(cacheBehaviors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheBehaviors(Consumer<CacheBehaviorPerPath.Builder> ... cacheBehaviors) {
            this.cacheBehaviors(Stream.of(cacheBehaviors).map(c -> (CacheBehaviorPerPath)((CacheBehaviorPerPath.Builder)CacheBehaviorPerPath.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCacheBehaviors(Collection<CacheBehaviorPerPath.BuilderImpl> cacheBehaviors) {
            this.cacheBehaviors = CacheBehaviorListCopier.copyFromBuilder(cacheBehaviors);
        }

        public final Boolean getAbleToUpdateBundle() {
            return this.ableToUpdateBundle;
        }

        @Override
        public final Builder ableToUpdateBundle(Boolean ableToUpdateBundle) {
            this.ableToUpdateBundle = ableToUpdateBundle;
            return this;
        }

        public final void setAbleToUpdateBundle(Boolean ableToUpdateBundle) {
            this.ableToUpdateBundle = ableToUpdateBundle;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public LightsailDistribution build() {
            return new LightsailDistribution(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LightsailDistribution> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder supportCode(String var1);

        public Builder createdAt(Instant var1);

        public Builder location(ResourceLocation var1);

        default public Builder location(Consumer<ResourceLocation.Builder> location) {
            return this.location((ResourceLocation)((ResourceLocation.Builder)ResourceLocation.builder().applyMutation(location)).build());
        }

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder alternativeDomainNames(Collection<String> var1);

        public Builder alternativeDomainNames(String ... var1);

        public Builder status(String var1);

        public Builder isEnabled(Boolean var1);

        public Builder domainName(String var1);

        public Builder bundleId(String var1);

        public Builder certificateName(String var1);

        public Builder origin(Origin var1);

        default public Builder origin(Consumer<Origin.Builder> origin) {
            return this.origin((Origin)((Origin.Builder)Origin.builder().applyMutation(origin)).build());
        }

        public Builder originPublicDNS(String var1);

        public Builder defaultCacheBehavior(CacheBehavior var1);

        default public Builder defaultCacheBehavior(Consumer<CacheBehavior.Builder> defaultCacheBehavior) {
            return this.defaultCacheBehavior((CacheBehavior)((CacheBehavior.Builder)CacheBehavior.builder().applyMutation(defaultCacheBehavior)).build());
        }

        public Builder cacheBehaviorSettings(CacheSettings var1);

        default public Builder cacheBehaviorSettings(Consumer<CacheSettings.Builder> cacheBehaviorSettings) {
            return this.cacheBehaviorSettings((CacheSettings)((CacheSettings.Builder)CacheSettings.builder().applyMutation(cacheBehaviorSettings)).build());
        }

        public Builder cacheBehaviors(Collection<CacheBehaviorPerPath> var1);

        public Builder cacheBehaviors(CacheBehaviorPerPath ... var1);

        public Builder cacheBehaviors(Consumer<CacheBehaviorPerPath.Builder> ... var1);

        public Builder ableToUpdateBundle(Boolean var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

