/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateRelationalDatabaseRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, UpdateRelationalDatabaseRequest> {
    private static final SdkField<String> RELATIONAL_DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateRelationalDatabaseRequest.getter(UpdateRelationalDatabaseRequest::relationalDatabaseName)).setter(UpdateRelationalDatabaseRequest.setter(Builder::relationalDatabaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationalDatabaseName").build()}).build();
    private static final SdkField<String> MASTER_USER_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateRelationalDatabaseRequest.getter(UpdateRelationalDatabaseRequest::masterUserPassword)).setter(UpdateRelationalDatabaseRequest.setter(Builder::masterUserPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("masterUserPassword").build()}).build();
    private static final SdkField<Boolean> ROTATE_MASTER_USER_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(UpdateRelationalDatabaseRequest.getter(UpdateRelationalDatabaseRequest::rotateMasterUserPassword)).setter(UpdateRelationalDatabaseRequest.setter(Builder::rotateMasterUserPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rotateMasterUserPassword").build()}).build();
    private static final SdkField<String> PREFERRED_BACKUP_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateRelationalDatabaseRequest.getter(UpdateRelationalDatabaseRequest::preferredBackupWindow)).setter(UpdateRelationalDatabaseRequest.setter(Builder::preferredBackupWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preferredBackupWindow").build()}).build();
    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateRelationalDatabaseRequest.getter(UpdateRelationalDatabaseRequest::preferredMaintenanceWindow)).setter(UpdateRelationalDatabaseRequest.setter(Builder::preferredMaintenanceWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preferredMaintenanceWindow").build()}).build();
    private static final SdkField<Boolean> ENABLE_BACKUP_RETENTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(UpdateRelationalDatabaseRequest.getter(UpdateRelationalDatabaseRequest::enableBackupRetention)).setter(UpdateRelationalDatabaseRequest.setter(Builder::enableBackupRetention)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableBackupRetention").build()}).build();
    private static final SdkField<Boolean> DISABLE_BACKUP_RETENTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(UpdateRelationalDatabaseRequest.getter(UpdateRelationalDatabaseRequest::disableBackupRetention)).setter(UpdateRelationalDatabaseRequest.setter(Builder::disableBackupRetention)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disableBackupRetention").build()}).build();
    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(UpdateRelationalDatabaseRequest.getter(UpdateRelationalDatabaseRequest::publiclyAccessible)).setter(UpdateRelationalDatabaseRequest.setter(Builder::publiclyAccessible)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publiclyAccessible").build()}).build();
    private static final SdkField<Boolean> APPLY_IMMEDIATELY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(UpdateRelationalDatabaseRequest.getter(UpdateRelationalDatabaseRequest::applyImmediately)).setter(UpdateRelationalDatabaseRequest.setter(Builder::applyImmediately)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applyImmediately").build()}).build();
    private static final SdkField<String> CA_CERTIFICATE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateRelationalDatabaseRequest.getter(UpdateRelationalDatabaseRequest::caCertificateIdentifier)).setter(UpdateRelationalDatabaseRequest.setter(Builder::caCertificateIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caCertificateIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RELATIONAL_DATABASE_NAME_FIELD, MASTER_USER_PASSWORD_FIELD, ROTATE_MASTER_USER_PASSWORD_FIELD, PREFERRED_BACKUP_WINDOW_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, ENABLE_BACKUP_RETENTION_FIELD, DISABLE_BACKUP_RETENTION_FIELD, PUBLICLY_ACCESSIBLE_FIELD, APPLY_IMMEDIATELY_FIELD, CA_CERTIFICATE_IDENTIFIER_FIELD));
    private final String relationalDatabaseName;
    private final String masterUserPassword;
    private final Boolean rotateMasterUserPassword;
    private final String preferredBackupWindow;
    private final String preferredMaintenanceWindow;
    private final Boolean enableBackupRetention;
    private final Boolean disableBackupRetention;
    private final Boolean publiclyAccessible;
    private final Boolean applyImmediately;
    private final String caCertificateIdentifier;

    private UpdateRelationalDatabaseRequest(BuilderImpl builder) {
        super(builder);
        this.relationalDatabaseName = builder.relationalDatabaseName;
        this.masterUserPassword = builder.masterUserPassword;
        this.rotateMasterUserPassword = builder.rotateMasterUserPassword;
        this.preferredBackupWindow = builder.preferredBackupWindow;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.enableBackupRetention = builder.enableBackupRetention;
        this.disableBackupRetention = builder.disableBackupRetention;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.applyImmediately = builder.applyImmediately;
        this.caCertificateIdentifier = builder.caCertificateIdentifier;
    }

    public String relationalDatabaseName() {
        return this.relationalDatabaseName;
    }

    public String masterUserPassword() {
        return this.masterUserPassword;
    }

    public Boolean rotateMasterUserPassword() {
        return this.rotateMasterUserPassword;
    }

    public String preferredBackupWindow() {
        return this.preferredBackupWindow;
    }

    public String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public Boolean enableBackupRetention() {
        return this.enableBackupRetention;
    }

    public Boolean disableBackupRetention() {
        return this.disableBackupRetention;
    }

    public Boolean publiclyAccessible() {
        return this.publiclyAccessible;
    }

    public Boolean applyImmediately() {
        return this.applyImmediately;
    }

    public String caCertificateIdentifier() {
        return this.caCertificateIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.relationalDatabaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.rotateMasterUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredBackupWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableBackupRetention());
        hashCode = 31 * hashCode + Objects.hashCode(this.disableBackupRetention());
        hashCode = 31 * hashCode + Objects.hashCode(this.publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(this.applyImmediately());
        hashCode = 31 * hashCode + Objects.hashCode(this.caCertificateIdentifier());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRelationalDatabaseRequest)) {
            return false;
        }
        UpdateRelationalDatabaseRequest other = (UpdateRelationalDatabaseRequest)((Object)obj);
        return Objects.equals(this.relationalDatabaseName(), other.relationalDatabaseName()) && Objects.equals(this.masterUserPassword(), other.masterUserPassword()) && Objects.equals(this.rotateMasterUserPassword(), other.rotateMasterUserPassword()) && Objects.equals(this.preferredBackupWindow(), other.preferredBackupWindow()) && Objects.equals(this.preferredMaintenanceWindow(), other.preferredMaintenanceWindow()) && Objects.equals(this.enableBackupRetention(), other.enableBackupRetention()) && Objects.equals(this.disableBackupRetention(), other.disableBackupRetention()) && Objects.equals(this.publiclyAccessible(), other.publiclyAccessible()) && Objects.equals(this.applyImmediately(), other.applyImmediately()) && Objects.equals(this.caCertificateIdentifier(), other.caCertificateIdentifier());
    }

    public String toString() {
        return ToString.builder((String)"UpdateRelationalDatabaseRequest").add("RelationalDatabaseName", (Object)this.relationalDatabaseName()).add("MasterUserPassword", (Object)(this.masterUserPassword() == null ? null : "*** Sensitive Data Redacted ***")).add("RotateMasterUserPassword", (Object)this.rotateMasterUserPassword()).add("PreferredBackupWindow", (Object)this.preferredBackupWindow()).add("PreferredMaintenanceWindow", (Object)this.preferredMaintenanceWindow()).add("EnableBackupRetention", (Object)this.enableBackupRetention()).add("DisableBackupRetention", (Object)this.disableBackupRetention()).add("PubliclyAccessible", (Object)this.publiclyAccessible()).add("ApplyImmediately", (Object)this.applyImmediately()).add("CaCertificateIdentifier", (Object)this.caCertificateIdentifier()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "relationalDatabaseName": {
                return Optional.ofNullable(clazz.cast(this.relationalDatabaseName()));
            }
            case "masterUserPassword": {
                return Optional.ofNullable(clazz.cast(this.masterUserPassword()));
            }
            case "rotateMasterUserPassword": {
                return Optional.ofNullable(clazz.cast(this.rotateMasterUserPassword()));
            }
            case "preferredBackupWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredBackupWindow()));
            }
            case "preferredMaintenanceWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredMaintenanceWindow()));
            }
            case "enableBackupRetention": {
                return Optional.ofNullable(clazz.cast(this.enableBackupRetention()));
            }
            case "disableBackupRetention": {
                return Optional.ofNullable(clazz.cast(this.disableBackupRetention()));
            }
            case "publiclyAccessible": {
                return Optional.ofNullable(clazz.cast(this.publiclyAccessible()));
            }
            case "applyImmediately": {
                return Optional.ofNullable(clazz.cast(this.applyImmediately()));
            }
            case "caCertificateIdentifier": {
                return Optional.ofNullable(clazz.cast(this.caCertificateIdentifier()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRelationalDatabaseRequest, T> g) {
        return obj -> g.apply((UpdateRelationalDatabaseRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private String relationalDatabaseName;
        private String masterUserPassword;
        private Boolean rotateMasterUserPassword;
        private String preferredBackupWindow;
        private String preferredMaintenanceWindow;
        private Boolean enableBackupRetention;
        private Boolean disableBackupRetention;
        private Boolean publiclyAccessible;
        private Boolean applyImmediately;
        private String caCertificateIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRelationalDatabaseRequest model) {
            super(model);
            this.relationalDatabaseName(model.relationalDatabaseName);
            this.masterUserPassword(model.masterUserPassword);
            this.rotateMasterUserPassword(model.rotateMasterUserPassword);
            this.preferredBackupWindow(model.preferredBackupWindow);
            this.preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.enableBackupRetention(model.enableBackupRetention);
            this.disableBackupRetention(model.disableBackupRetention);
            this.publiclyAccessible(model.publiclyAccessible);
            this.applyImmediately(model.applyImmediately);
            this.caCertificateIdentifier(model.caCertificateIdentifier);
        }

        public final String getRelationalDatabaseName() {
            return this.relationalDatabaseName;
        }

        @Override
        public final Builder relationalDatabaseName(String relationalDatabaseName) {
            this.relationalDatabaseName = relationalDatabaseName;
            return this;
        }

        public final void setRelationalDatabaseName(String relationalDatabaseName) {
            this.relationalDatabaseName = relationalDatabaseName;
        }

        public final String getMasterUserPassword() {
            return this.masterUserPassword;
        }

        @Override
        public final Builder masterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
            return this;
        }

        public final void setMasterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
        }

        public final Boolean getRotateMasterUserPassword() {
            return this.rotateMasterUserPassword;
        }

        @Override
        public final Builder rotateMasterUserPassword(Boolean rotateMasterUserPassword) {
            this.rotateMasterUserPassword = rotateMasterUserPassword;
            return this;
        }

        public final void setRotateMasterUserPassword(Boolean rotateMasterUserPassword) {
            this.rotateMasterUserPassword = rotateMasterUserPassword;
        }

        public final String getPreferredBackupWindow() {
            return this.preferredBackupWindow;
        }

        @Override
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final Boolean getEnableBackupRetention() {
            return this.enableBackupRetention;
        }

        @Override
        public final Builder enableBackupRetention(Boolean enableBackupRetention) {
            this.enableBackupRetention = enableBackupRetention;
            return this;
        }

        public final void setEnableBackupRetention(Boolean enableBackupRetention) {
            this.enableBackupRetention = enableBackupRetention;
        }

        public final Boolean getDisableBackupRetention() {
            return this.disableBackupRetention;
        }

        @Override
        public final Builder disableBackupRetention(Boolean disableBackupRetention) {
            this.disableBackupRetention = disableBackupRetention;
            return this;
        }

        public final void setDisableBackupRetention(Boolean disableBackupRetention) {
            this.disableBackupRetention = disableBackupRetention;
        }

        public final Boolean getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        public final Boolean getApplyImmediately() {
            return this.applyImmediately;
        }

        @Override
        public final Builder applyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
            return this;
        }

        public final void setApplyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
        }

        public final String getCaCertificateIdentifier() {
            return this.caCertificateIdentifier;
        }

        @Override
        public final Builder caCertificateIdentifier(String caCertificateIdentifier) {
            this.caCertificateIdentifier = caCertificateIdentifier;
            return this;
        }

        public final void setCaCertificateIdentifier(String caCertificateIdentifier) {
            this.caCertificateIdentifier = caCertificateIdentifier;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRelationalDatabaseRequest build() {
            return new UpdateRelationalDatabaseRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateRelationalDatabaseRequest> {
        public Builder relationalDatabaseName(String var1);

        public Builder masterUserPassword(String var1);

        public Builder rotateMasterUserPassword(Boolean var1);

        public Builder preferredBackupWindow(String var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder enableBackupRetention(Boolean var1);

        public Builder disableBackupRetention(Boolean var1);

        public Builder publiclyAccessible(Boolean var1);

        public Builder applyImmediately(Boolean var1);

        public Builder caCertificateIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

