/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDiskRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, CreateDiskRequest> {
    private static final SdkField<String> DISK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDiskRequest.getter(CreateDiskRequest::diskName)).setter(CreateDiskRequest.setter(Builder::diskName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("diskName").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDiskRequest.getter(CreateDiskRequest::availabilityZone)).setter(CreateDiskRequest.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()}).build();
    private static final SdkField<Integer> SIZE_IN_GB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CreateDiskRequest.getter(CreateDiskRequest::sizeInGb)).setter(CreateDiskRequest.setter(Builder::sizeInGb)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sizeInGb").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISK_NAME_FIELD, AVAILABILITY_ZONE_FIELD, SIZE_IN_GB_FIELD));
    private final String diskName;
    private final String availabilityZone;
    private final Integer sizeInGb;

    private CreateDiskRequest(BuilderImpl builder) {
        super(builder);
        this.diskName = builder.diskName;
        this.availabilityZone = builder.availabilityZone;
        this.sizeInGb = builder.sizeInGb;
    }

    public String diskName() {
        return this.diskName;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public Integer sizeInGb() {
        return this.sizeInGb;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.diskName());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeInGb());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDiskRequest)) {
            return false;
        }
        CreateDiskRequest other = (CreateDiskRequest)((Object)obj);
        return Objects.equals(this.diskName(), other.diskName()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.sizeInGb(), other.sizeInGb());
    }

    public String toString() {
        return ToString.builder((String)"CreateDiskRequest").add("DiskName", (Object)this.diskName()).add("AvailabilityZone", (Object)this.availabilityZone()).add("SizeInGb", (Object)this.sizeInGb()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "diskName": {
                return Optional.ofNullable(clazz.cast(this.diskName()));
            }
            case "availabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "sizeInGb": {
                return Optional.ofNullable(clazz.cast(this.sizeInGb()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDiskRequest, T> g) {
        return obj -> g.apply((CreateDiskRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private String diskName;
        private String availabilityZone;
        private Integer sizeInGb;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDiskRequest model) {
            super(model);
            this.diskName(model.diskName);
            this.availabilityZone(model.availabilityZone);
            this.sizeInGb(model.sizeInGb);
        }

        public final String getDiskName() {
            return this.diskName;
        }

        @Override
        public final Builder diskName(String diskName) {
            this.diskName = diskName;
            return this;
        }

        public final void setDiskName(String diskName) {
            this.diskName = diskName;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Integer getSizeInGb() {
            return this.sizeInGb;
        }

        @Override
        public final Builder sizeInGb(Integer sizeInGb) {
            this.sizeInGb = sizeInGb;
            return this;
        }

        public final void setSizeInGb(Integer sizeInGb) {
            this.sizeInGb = sizeInGb;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDiskRequest build() {
            return new CreateDiskRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDiskRequest> {
        public Builder diskName(String var1);

        public Builder availabilityZone(String var1);

        public Builder sizeInGb(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

