/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateInstanceSnapshotRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, CreateInstanceSnapshotRequest> {
    private static final SdkField<String> INSTANCE_SNAPSHOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateInstanceSnapshotRequest.getter(CreateInstanceSnapshotRequest::instanceSnapshotName)).setter(CreateInstanceSnapshotRequest.setter(Builder::instanceSnapshotName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceSnapshotName").build()}).build();
    private static final SdkField<String> INSTANCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateInstanceSnapshotRequest.getter(CreateInstanceSnapshotRequest::instanceName)).setter(CreateInstanceSnapshotRequest.setter(Builder::instanceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_SNAPSHOT_NAME_FIELD, INSTANCE_NAME_FIELD));
    private final String instanceSnapshotName;
    private final String instanceName;

    private CreateInstanceSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.instanceSnapshotName = builder.instanceSnapshotName;
        this.instanceName = builder.instanceName;
    }

    public String instanceSnapshotName() {
        return this.instanceSnapshotName;
    }

    public String instanceName() {
        return this.instanceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceSnapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInstanceSnapshotRequest)) {
            return false;
        }
        CreateInstanceSnapshotRequest other = (CreateInstanceSnapshotRequest)((Object)obj);
        return Objects.equals(this.instanceSnapshotName(), other.instanceSnapshotName()) && Objects.equals(this.instanceName(), other.instanceName());
    }

    public String toString() {
        return ToString.builder((String)"CreateInstanceSnapshotRequest").add("InstanceSnapshotName", (Object)this.instanceSnapshotName()).add("InstanceName", (Object)this.instanceName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceSnapshotName": {
                return Optional.ofNullable(clazz.cast(this.instanceSnapshotName()));
            }
            case "instanceName": {
                return Optional.ofNullable(clazz.cast(this.instanceName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateInstanceSnapshotRequest, T> g) {
        return obj -> g.apply((CreateInstanceSnapshotRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private String instanceSnapshotName;
        private String instanceName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInstanceSnapshotRequest model) {
            super(model);
            this.instanceSnapshotName(model.instanceSnapshotName);
            this.instanceName(model.instanceName);
        }

        public final String getInstanceSnapshotName() {
            return this.instanceSnapshotName;
        }

        @Override
        public final Builder instanceSnapshotName(String instanceSnapshotName) {
            this.instanceSnapshotName = instanceSnapshotName;
            return this;
        }

        public final void setInstanceSnapshotName(String instanceSnapshotName) {
            this.instanceSnapshotName = instanceSnapshotName;
        }

        public final String getInstanceName() {
            return this.instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateInstanceSnapshotRequest build() {
            return new CreateInstanceSnapshotRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateInstanceSnapshotRequest> {
        public Builder instanceSnapshotName(String var1);

        public Builder instanceName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

