/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.model.InstanceSnapshot;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class InstanceSnapshotMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").isBinary(false).build();
    private static final MarshallingInfo<String> SUPPORTCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("supportCode").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("location").isBinary(false).build();
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceType").isBinary(false).build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("state").isBinary(false).build();
    private static final MarshallingInfo<String> PROGRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("progress").isBinary(false).build();
    private static final MarshallingInfo<List> FROMATTACHEDDISKS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fromAttachedDisks").isBinary(false).build();
    private static final MarshallingInfo<String> FROMINSTANCENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fromInstanceName").isBinary(false).build();
    private static final MarshallingInfo<String> FROMINSTANCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fromInstanceArn").isBinary(false).build();
    private static final MarshallingInfo<String> FROMBLUEPRINTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fromBlueprintId").isBinary(false).build();
    private static final MarshallingInfo<String> FROMBUNDLEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fromBundleId").isBinary(false).build();
    private static final MarshallingInfo<Integer> SIZEINGB_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sizeInGb").isBinary(false).build();
    private static final InstanceSnapshotMarshaller INSTANCE = new InstanceSnapshotMarshaller();

    private InstanceSnapshotMarshaller() {
    }

    public static InstanceSnapshotMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InstanceSnapshot instanceSnapshot, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)instanceSnapshot, (String)"instanceSnapshot");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)instanceSnapshot.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)instanceSnapshot.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)instanceSnapshot.supportCode(), SUPPORTCODE_BINDING);
            protocolMarshaller.marshall((Object)instanceSnapshot.createdAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)instanceSnapshot.location(), LOCATION_BINDING);
            protocolMarshaller.marshall((Object)instanceSnapshot.resourceTypeString(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall((Object)instanceSnapshot.stateString(), STATE_BINDING);
            protocolMarshaller.marshall((Object)instanceSnapshot.progress(), PROGRESS_BINDING);
            protocolMarshaller.marshall(instanceSnapshot.fromAttachedDisks(), FROMATTACHEDDISKS_BINDING);
            protocolMarshaller.marshall((Object)instanceSnapshot.fromInstanceName(), FROMINSTANCENAME_BINDING);
            protocolMarshaller.marshall((Object)instanceSnapshot.fromInstanceArn(), FROMINSTANCEARN_BINDING);
            protocolMarshaller.marshall((Object)instanceSnapshot.fromBlueprintId(), FROMBLUEPRINTID_BINDING);
            protocolMarshaller.marshall((Object)instanceSnapshot.fromBundleId(), FROMBUNDLEID_BINDING);
            protocolMarshaller.marshall((Object)instanceSnapshot.sizeInGb(), SIZEINGB_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

