/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lightsail.model.CreateDiskRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateDiskRequestModelMarshaller {
    private static final MarshallingInfo<String> DISKNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("diskName").isBinary(false).build();
    private static final MarshallingInfo<String> AVAILABILITYZONE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("availabilityZone").isBinary(false).build();
    private static final MarshallingInfo<Integer> SIZEINGB_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sizeInGb").isBinary(false).build();
    private static final CreateDiskRequestModelMarshaller INSTANCE = new CreateDiskRequestModelMarshaller();

    private CreateDiskRequestModelMarshaller() {
    }

    public static CreateDiskRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateDiskRequest createDiskRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createDiskRequest), (String)"createDiskRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createDiskRequest.diskName(), DISKNAME_BINDING);
            protocolMarshaller.marshall((Object)createDiskRequest.availabilityZone(), AVAILABILITYZONE_BINDING);
            protocolMarshaller.marshall((Object)createDiskRequest.sizeInGb(), SIZEINGB_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

