/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateInstanceSnapshotRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, CreateInstanceSnapshotRequest> {
    private final String instanceSnapshotName;
    private final String instanceName;

    private CreateInstanceSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.instanceSnapshotName = builder.instanceSnapshotName;
        this.instanceName = builder.instanceName;
    }

    public String instanceSnapshotName() {
        return this.instanceSnapshotName;
    }

    public String instanceName() {
        return this.instanceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceSnapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInstanceSnapshotRequest)) {
            return false;
        }
        CreateInstanceSnapshotRequest other = (CreateInstanceSnapshotRequest)((Object)obj);
        return Objects.equals(this.instanceSnapshotName(), other.instanceSnapshotName()) && Objects.equals(this.instanceName(), other.instanceName());
    }

    public String toString() {
        return ToString.builder((String)"CreateInstanceSnapshotRequest").add("InstanceSnapshotName", (Object)this.instanceSnapshotName()).add("InstanceName", (Object)this.instanceName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceSnapshotName": {
                return Optional.of(clazz.cast(this.instanceSnapshotName()));
            }
            case "instanceName": {
                return Optional.of(clazz.cast(this.instanceName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private String instanceSnapshotName;
        private String instanceName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInstanceSnapshotRequest model) {
            this.instanceSnapshotName(model.instanceSnapshotName);
            this.instanceName(model.instanceName);
        }

        public final String getInstanceSnapshotName() {
            return this.instanceSnapshotName;
        }

        @Override
        public final Builder instanceSnapshotName(String instanceSnapshotName) {
            this.instanceSnapshotName = instanceSnapshotName;
            return this;
        }

        public final void setInstanceSnapshotName(String instanceSnapshotName) {
            this.instanceSnapshotName = instanceSnapshotName;
        }

        public final String getInstanceName() {
            return this.instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateInstanceSnapshotRequest build() {
            return new CreateInstanceSnapshotRequest(this);
        }
    }

    public static interface Builder
    extends LightsailRequest.Builder,
    CopyableBuilder<Builder, CreateInstanceSnapshotRequest> {
        public Builder instanceSnapshotName(String var1);

        public Builder instanceName(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

