/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AttachStaticIpRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, AttachStaticIpRequest> {
    private final String staticIpName;
    private final String instanceName;

    private AttachStaticIpRequest(BuilderImpl builder) {
        super(builder);
        this.staticIpName = builder.staticIpName;
        this.instanceName = builder.instanceName;
    }

    public String staticIpName() {
        return this.staticIpName;
    }

    public String instanceName() {
        return this.instanceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.staticIpName());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachStaticIpRequest)) {
            return false;
        }
        AttachStaticIpRequest other = (AttachStaticIpRequest)((Object)obj);
        return Objects.equals(this.staticIpName(), other.staticIpName()) && Objects.equals(this.instanceName(), other.instanceName());
    }

    public String toString() {
        return ToString.builder((String)"AttachStaticIpRequest").add("StaticIpName", (Object)this.staticIpName()).add("InstanceName", (Object)this.instanceName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "staticIpName": {
                return Optional.of(clazz.cast(this.staticIpName()));
            }
            case "instanceName": {
                return Optional.of(clazz.cast(this.instanceName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private String staticIpName;
        private String instanceName;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachStaticIpRequest model) {
            this.staticIpName(model.staticIpName);
            this.instanceName(model.instanceName);
        }

        public final String getStaticIpName() {
            return this.staticIpName;
        }

        @Override
        public final Builder staticIpName(String staticIpName) {
            this.staticIpName = staticIpName;
            return this;
        }

        public final void setStaticIpName(String staticIpName) {
            this.staticIpName = staticIpName;
        }

        public final String getInstanceName() {
            return this.instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public AttachStaticIpRequest build() {
            return new AttachStaticIpRequest(this);
        }
    }

    public static interface Builder
    extends LightsailRequest.Builder,
    CopyableBuilder<Builder, AttachStaticIpRequest> {
        public Builder staticIpName(String var1);

        public Builder instanceName(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

