/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.model.InstanceNetworking;

@SdkInternalApi
public class InstanceNetworkingMarshaller {
    private static final MarshallingInfo<StructuredPojo> MONTHLYTRANSFER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("monthlyTransfer").build();
    private static final MarshallingInfo<List> PORTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ports").build();
    private static final InstanceNetworkingMarshaller INSTANCE = new InstanceNetworkingMarshaller();

    public static InstanceNetworkingMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InstanceNetworking instanceNetworking, ProtocolMarshaller protocolMarshaller) {
        if (instanceNetworking == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)instanceNetworking.monthlyTransfer(), MONTHLYTRANSFER_BINDING);
            protocolMarshaller.marshall(instanceNetworking.ports(), PORTS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

