/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lightsail.model.DiskMap;

@SdkInternalApi
public class DiskMapMarshaller {
    private static final MarshallingInfo<String> ORIGINALDISKPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("originalDiskPath").build();
    private static final MarshallingInfo<String> NEWDISKNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("newDiskName").build();
    private static final DiskMapMarshaller INSTANCE = new DiskMapMarshaller();

    public static DiskMapMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DiskMap diskMap, ProtocolMarshaller protocolMarshaller) {
        if (diskMap == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)diskMap.originalDiskPath(), ORIGINALDISKPATH_BINDING);
            protocolMarshaller.marshall((Object)diskMap.newDiskName(), NEWDISKNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

