/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.lightsail.model.Disk;
import software.amazon.awssdk.services.lightsail.model.DiskListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetDisksResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetDisksResponse> {
    private final List<Disk> disks;
    private final String nextPageToken;

    private GetDisksResponse(BuilderImpl builder) {
        this.disks = builder.disks;
        this.nextPageToken = builder.nextPageToken;
    }

    public List<Disk> disks() {
        return this.disks;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.disks());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDisksResponse)) {
            return false;
        }
        GetDisksResponse other = (GetDisksResponse)((Object)obj);
        return Objects.equals(this.disks(), other.disks()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.disks() != null) {
            sb.append("Disks: ").append(this.disks()).append(",");
        }
        if (this.nextPageToken() != null) {
            sb.append("NextPageToken: ").append(this.nextPageToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "disks": {
                return Optional.of(clazz.cast(this.disks()));
            }
            case "nextPageToken": {
                return Optional.of(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<Disk> disks;
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDisksResponse model) {
            this.disks(model.disks);
            this.nextPageToken(model.nextPageToken);
        }

        public final Collection<Disk.Builder> getDisks() {
            return this.disks != null ? (Collection)this.disks.stream().map(Disk::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder disks(Collection<Disk> disks) {
            this.disks = DiskListCopier.copy(disks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder disks(Disk ... disks) {
            this.disks(Arrays.asList(disks));
            return this;
        }

        public final void setDisks(Collection<Disk.BuilderImpl> disks) {
            this.disks = DiskListCopier.copyFromBuilder(disks);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        public GetDisksResponse build() {
            return new GetDisksResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetDisksResponse> {
        public Builder disks(Collection<Disk> var1);

        public Builder disks(Disk ... var1);

        public Builder nextPageToken(String var1);
    }
}

