/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.model.InstancePortInfo;
import software.amazon.awssdk.services.lightsail.model.InstancePortInfoListCopier;
import software.amazon.awssdk.services.lightsail.model.MonthlyTransfer;
import software.amazon.awssdk.services.lightsail.transform.InstanceNetworkingMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceNetworking
implements StructuredPojo,
ToCopyableBuilder<Builder, InstanceNetworking> {
    private final MonthlyTransfer monthlyTransfer;
    private final List<InstancePortInfo> ports;

    private InstanceNetworking(BuilderImpl builder) {
        this.monthlyTransfer = builder.monthlyTransfer;
        this.ports = builder.ports;
    }

    public MonthlyTransfer monthlyTransfer() {
        return this.monthlyTransfer;
    }

    public List<InstancePortInfo> ports() {
        return this.ports;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.monthlyTransfer() == null ? 0 : this.monthlyTransfer().hashCode());
        hashCode = 31 * hashCode + (this.ports() == null ? 0 : this.ports().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceNetworking)) {
            return false;
        }
        InstanceNetworking other = (InstanceNetworking)obj;
        if (other.monthlyTransfer() == null ^ this.monthlyTransfer() == null) {
            return false;
        }
        if (other.monthlyTransfer() != null && !other.monthlyTransfer().equals(this.monthlyTransfer())) {
            return false;
        }
        if (other.ports() == null ^ this.ports() == null) {
            return false;
        }
        return other.ports() == null || other.ports().equals(this.ports());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.monthlyTransfer() != null) {
            sb.append("MonthlyTransfer: ").append(this.monthlyTransfer()).append(",");
        }
        if (this.ports() != null) {
            sb.append("Ports: ").append(this.ports()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "monthlyTransfer": {
                return Optional.of(clazz.cast(this.monthlyTransfer()));
            }
            case "ports": {
                return Optional.of(clazz.cast(this.ports()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceNetworkingMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private MonthlyTransfer monthlyTransfer;
        private List<InstancePortInfo> ports;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceNetworking model) {
            this.monthlyTransfer(model.monthlyTransfer);
            this.ports(model.ports);
        }

        public final MonthlyTransfer.Builder getMonthlyTransfer() {
            return this.monthlyTransfer != null ? this.monthlyTransfer.toBuilder() : null;
        }

        @Override
        public final Builder monthlyTransfer(MonthlyTransfer monthlyTransfer) {
            this.monthlyTransfer = monthlyTransfer;
            return this;
        }

        public final void setMonthlyTransfer(MonthlyTransfer.BuilderImpl monthlyTransfer) {
            this.monthlyTransfer = monthlyTransfer != null ? monthlyTransfer.build() : null;
        }

        public final Collection<InstancePortInfo.Builder> getPorts() {
            return this.ports != null ? (Collection)this.ports.stream().map(InstancePortInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ports(Collection<InstancePortInfo> ports) {
            this.ports = InstancePortInfoListCopier.copy(ports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ports(InstancePortInfo ... ports) {
            this.ports(Arrays.asList(ports));
            return this;
        }

        public final void setPorts(Collection<InstancePortInfo.BuilderImpl> ports) {
            this.ports = InstancePortInfoListCopier.copyFromBuilder(ports);
        }

        public InstanceNetworking build() {
            return new InstanceNetworking(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceNetworking> {
        public Builder monthlyTransfer(MonthlyTransfer var1);

        public Builder ports(Collection<InstancePortInfo> var1);

        public Builder ports(InstancePortInfo ... var1);
    }
}

