/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetOperationsForResourceRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetOperationsForResourceRequest> {
    private final String resourceName;
    private final String pageToken;

    private GetOperationsForResourceRequest(BuilderImpl builder) {
        this.resourceName = builder.resourceName;
        this.pageToken = builder.pageToken;
    }

    public String resourceName() {
        return this.resourceName;
    }

    public String pageToken() {
        return this.pageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.resourceName() == null ? 0 : this.resourceName().hashCode());
        hashCode = 31 * hashCode + (this.pageToken() == null ? 0 : this.pageToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOperationsForResourceRequest)) {
            return false;
        }
        GetOperationsForResourceRequest other = (GetOperationsForResourceRequest)((Object)obj);
        if (other.resourceName() == null ^ this.resourceName() == null) {
            return false;
        }
        if (other.resourceName() != null && !other.resourceName().equals(this.resourceName())) {
            return false;
        }
        if (other.pageToken() == null ^ this.pageToken() == null) {
            return false;
        }
        return other.pageToken() == null || other.pageToken().equals(this.pageToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.resourceName() != null) {
            sb.append("ResourceName: ").append(this.resourceName()).append(",");
        }
        if (this.pageToken() != null) {
            sb.append("PageToken: ").append(this.pageToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceName": {
                return Optional.of(clazz.cast(this.resourceName()));
            }
            case "pageToken": {
                return Optional.of(clazz.cast(this.pageToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceName;
        private String pageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOperationsForResourceRequest model) {
            this.resourceName(model.resourceName);
            this.pageToken(model.pageToken);
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        public final String getPageToken() {
            return this.pageToken;
        }

        @Override
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        public GetOperationsForResourceRequest build() {
            return new GetOperationsForResourceRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetOperationsForResourceRequest> {
        public Builder resourceName(String var1);

        public Builder pageToken(String var1);
    }
}

