/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.lightsail.model.KeyPair;
import software.amazon.awssdk.services.lightsail.model.KeyPairListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetKeyPairsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetKeyPairsResponse> {
    private final List<KeyPair> keyPairs;
    private final String nextPageToken;

    private GetKeyPairsResponse(BuilderImpl builder) {
        this.keyPairs = builder.keyPairs;
        this.nextPageToken = builder.nextPageToken;
    }

    public List<KeyPair> keyPairs() {
        return this.keyPairs;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.keyPairs() == null ? 0 : this.keyPairs().hashCode());
        hashCode = 31 * hashCode + (this.nextPageToken() == null ? 0 : this.nextPageToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetKeyPairsResponse)) {
            return false;
        }
        GetKeyPairsResponse other = (GetKeyPairsResponse)((Object)obj);
        if (other.keyPairs() == null ^ this.keyPairs() == null) {
            return false;
        }
        if (other.keyPairs() != null && !other.keyPairs().equals(this.keyPairs())) {
            return false;
        }
        if (other.nextPageToken() == null ^ this.nextPageToken() == null) {
            return false;
        }
        return other.nextPageToken() == null || other.nextPageToken().equals(this.nextPageToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.keyPairs() != null) {
            sb.append("KeyPairs: ").append(this.keyPairs()).append(",");
        }
        if (this.nextPageToken() != null) {
            sb.append("NextPageToken: ").append(this.nextPageToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "keyPairs": {
                return Optional.of(clazz.cast(this.keyPairs()));
            }
            case "nextPageToken": {
                return Optional.of(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<KeyPair> keyPairs;
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetKeyPairsResponse model) {
            this.keyPairs(model.keyPairs);
            this.nextPageToken(model.nextPageToken);
        }

        public final Collection<KeyPair.Builder> getKeyPairs() {
            return this.keyPairs != null ? (Collection)this.keyPairs.stream().map(KeyPair::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder keyPairs(Collection<KeyPair> keyPairs) {
            this.keyPairs = KeyPairListCopier.copy(keyPairs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyPairs(KeyPair ... keyPairs) {
            this.keyPairs(Arrays.asList(keyPairs));
            return this;
        }

        public final void setKeyPairs(Collection<KeyPair.BuilderImpl> keyPairs) {
            this.keyPairs = KeyPairListCopier.copyFromBuilder(keyPairs);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        public GetKeyPairsResponse build() {
            return new GetKeyPairsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetKeyPairsResponse> {
        public Builder keyPairs(Collection<KeyPair> var1);

        public Builder keyPairs(KeyPair ... var1);

        public Builder nextPageToken(String var1);
    }
}

