/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.model.DomainEntryOptionsCopier;
import software.amazon.awssdk.services.lightsail.transform.DomainEntryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DomainEntry
implements StructuredPojo,
ToCopyableBuilder<Builder, DomainEntry> {
    private final String id;
    private final String name;
    private final String target;
    private final String type;
    private final Map<String, String> options;

    private DomainEntry(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.target = builder.target;
        this.type = builder.type;
        this.options = builder.options;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String target() {
        return this.target;
    }

    public String type() {
        return this.type;
    }

    public Map<String, String> options() {
        return this.options;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.target() == null ? 0 : this.target().hashCode());
        hashCode = 31 * hashCode + (this.type() == null ? 0 : this.type().hashCode());
        hashCode = 31 * hashCode + (this.options() == null ? 0 : this.options().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainEntry)) {
            return false;
        }
        DomainEntry other = (DomainEntry)obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.target() == null ^ this.target() == null) {
            return false;
        }
        if (other.target() != null && !other.target().equals(this.target())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.options() == null ^ this.options() == null) {
            return false;
        }
        return other.options() == null || other.options().equals(this.options());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.target() != null) {
            sb.append("Target: ").append(this.target()).append(",");
        }
        if (this.type() != null) {
            sb.append("Type: ").append(this.type()).append(",");
        }
        if (this.options() != null) {
            sb.append("Options: ").append(this.options()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "target": {
                return Optional.of(clazz.cast(this.target()));
            }
            case "type": {
                return Optional.of(clazz.cast(this.type()));
            }
            case "options": {
                return Optional.of(clazz.cast(this.options()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DomainEntryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String target;
        private String type;
        private Map<String, String> options;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainEntry model) {
            this.id(model.id);
            this.name(model.name);
            this.target(model.target);
            this.type(model.type);
            this.options(model.options);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getTarget() {
            return this.target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Map<String, String> getOptions() {
            return this.options;
        }

        @Override
        public final Builder options(Map<String, String> options) {
            this.options = DomainEntryOptionsCopier.copy(options);
            return this;
        }

        public final void setOptions(Map<String, String> options) {
            this.options = DomainEntryOptionsCopier.copy(options);
        }

        public DomainEntry build() {
            return new DomainEntry(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DomainEntry> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder target(String var1);

        public Builder type(String var1);

        public Builder options(Map<String, String> var1);
    }
}

