/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.time.Instant;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.model.InstanceSnapshotState;
import software.amazon.awssdk.services.lightsail.model.ResourceLocation;
import software.amazon.awssdk.services.lightsail.model.ResourceType;
import software.amazon.awssdk.services.lightsail.transform.InstanceSnapshotMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceSnapshot
implements StructuredPojo,
ToCopyableBuilder<Builder, InstanceSnapshot> {
    private final String name;
    private final String arn;
    private final String supportCode;
    private final Instant createdAt;
    private final ResourceLocation location;
    private final String resourceType;
    private final String state;
    private final String progress;
    private final String fromInstanceName;
    private final String fromInstanceArn;
    private final String fromBlueprintId;
    private final String fromBundleId;
    private final Integer sizeInGb;

    private InstanceSnapshot(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.supportCode = builder.supportCode;
        this.createdAt = builder.createdAt;
        this.location = builder.location;
        this.resourceType = builder.resourceType;
        this.state = builder.state;
        this.progress = builder.progress;
        this.fromInstanceName = builder.fromInstanceName;
        this.fromInstanceArn = builder.fromInstanceArn;
        this.fromBlueprintId = builder.fromBlueprintId;
        this.fromBundleId = builder.fromBundleId;
        this.sizeInGb = builder.sizeInGb;
    }

    public String name() {
        return this.name;
    }

    public String arn() {
        return this.arn;
    }

    public String supportCode() {
        return this.supportCode;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public ResourceLocation location() {
        return this.location;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public String state() {
        return this.state;
    }

    public String progress() {
        return this.progress;
    }

    public String fromInstanceName() {
        return this.fromInstanceName;
    }

    public String fromInstanceArn() {
        return this.fromInstanceArn;
    }

    public String fromBlueprintId() {
        return this.fromBlueprintId;
    }

    public String fromBundleId() {
        return this.fromBundleId;
    }

    public Integer sizeInGb() {
        return this.sizeInGb;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.arn() == null ? 0 : this.arn().hashCode());
        hashCode = 31 * hashCode + (this.supportCode() == null ? 0 : this.supportCode().hashCode());
        hashCode = 31 * hashCode + (this.createdAt() == null ? 0 : this.createdAt().hashCode());
        hashCode = 31 * hashCode + (this.location() == null ? 0 : this.location().hashCode());
        hashCode = 31 * hashCode + (this.resourceType() == null ? 0 : this.resourceType().hashCode());
        hashCode = 31 * hashCode + (this.state() == null ? 0 : this.state().hashCode());
        hashCode = 31 * hashCode + (this.progress() == null ? 0 : this.progress().hashCode());
        hashCode = 31 * hashCode + (this.fromInstanceName() == null ? 0 : this.fromInstanceName().hashCode());
        hashCode = 31 * hashCode + (this.fromInstanceArn() == null ? 0 : this.fromInstanceArn().hashCode());
        hashCode = 31 * hashCode + (this.fromBlueprintId() == null ? 0 : this.fromBlueprintId().hashCode());
        hashCode = 31 * hashCode + (this.fromBundleId() == null ? 0 : this.fromBundleId().hashCode());
        hashCode = 31 * hashCode + (this.sizeInGb() == null ? 0 : this.sizeInGb().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceSnapshot)) {
            return false;
        }
        InstanceSnapshot other = (InstanceSnapshot)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.supportCode() == null ^ this.supportCode() == null) {
            return false;
        }
        if (other.supportCode() != null && !other.supportCode().equals(this.supportCode())) {
            return false;
        }
        if (other.createdAt() == null ^ this.createdAt() == null) {
            return false;
        }
        if (other.createdAt() != null && !other.createdAt().equals(this.createdAt())) {
            return false;
        }
        if (other.location() == null ^ this.location() == null) {
            return false;
        }
        if (other.location() != null && !other.location().equals(this.location())) {
            return false;
        }
        if (other.resourceType() == null ^ this.resourceType() == null) {
            return false;
        }
        if (other.resourceType() != null && !other.resourceType().equals(this.resourceType())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.progress() == null ^ this.progress() == null) {
            return false;
        }
        if (other.progress() != null && !other.progress().equals(this.progress())) {
            return false;
        }
        if (other.fromInstanceName() == null ^ this.fromInstanceName() == null) {
            return false;
        }
        if (other.fromInstanceName() != null && !other.fromInstanceName().equals(this.fromInstanceName())) {
            return false;
        }
        if (other.fromInstanceArn() == null ^ this.fromInstanceArn() == null) {
            return false;
        }
        if (other.fromInstanceArn() != null && !other.fromInstanceArn().equals(this.fromInstanceArn())) {
            return false;
        }
        if (other.fromBlueprintId() == null ^ this.fromBlueprintId() == null) {
            return false;
        }
        if (other.fromBlueprintId() != null && !other.fromBlueprintId().equals(this.fromBlueprintId())) {
            return false;
        }
        if (other.fromBundleId() == null ^ this.fromBundleId() == null) {
            return false;
        }
        if (other.fromBundleId() != null && !other.fromBundleId().equals(this.fromBundleId())) {
            return false;
        }
        if (other.sizeInGb() == null ^ this.sizeInGb() == null) {
            return false;
        }
        return other.sizeInGb() == null || other.sizeInGb().equals(this.sizeInGb());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.arn() != null) {
            sb.append("Arn: ").append(this.arn()).append(",");
        }
        if (this.supportCode() != null) {
            sb.append("SupportCode: ").append(this.supportCode()).append(",");
        }
        if (this.createdAt() != null) {
            sb.append("CreatedAt: ").append(this.createdAt()).append(",");
        }
        if (this.location() != null) {
            sb.append("Location: ").append(this.location()).append(",");
        }
        if (this.resourceType() != null) {
            sb.append("ResourceType: ").append(this.resourceType()).append(",");
        }
        if (this.state() != null) {
            sb.append("State: ").append(this.state()).append(",");
        }
        if (this.progress() != null) {
            sb.append("Progress: ").append(this.progress()).append(",");
        }
        if (this.fromInstanceName() != null) {
            sb.append("FromInstanceName: ").append(this.fromInstanceName()).append(",");
        }
        if (this.fromInstanceArn() != null) {
            sb.append("FromInstanceArn: ").append(this.fromInstanceArn()).append(",");
        }
        if (this.fromBlueprintId() != null) {
            sb.append("FromBlueprintId: ").append(this.fromBlueprintId()).append(",");
        }
        if (this.fromBundleId() != null) {
            sb.append("FromBundleId: ").append(this.fromBundleId()).append(",");
        }
        if (this.sizeInGb() != null) {
            sb.append("SizeInGb: ").append(this.sizeInGb()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceSnapshotMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private String supportCode;
        private Instant createdAt;
        private ResourceLocation location;
        private String resourceType;
        private String state;
        private String progress;
        private String fromInstanceName;
        private String fromInstanceArn;
        private String fromBlueprintId;
        private String fromBundleId;
        private Integer sizeInGb;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceSnapshot model) {
            this.setName(model.name);
            this.setArn(model.arn);
            this.setSupportCode(model.supportCode);
            this.setCreatedAt(model.createdAt);
            this.setLocation(model.location);
            this.setResourceType(model.resourceType);
            this.setState(model.state);
            this.setProgress(model.progress);
            this.setFromInstanceName(model.fromInstanceName);
            this.setFromInstanceArn(model.fromInstanceArn);
            this.setFromBlueprintId(model.fromBlueprintId);
            this.setFromBundleId(model.fromBundleId);
            this.setSizeInGb(model.sizeInGb);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getSupportCode() {
            return this.supportCode;
        }

        @Override
        public final Builder supportCode(String supportCode) {
            this.supportCode = supportCode;
            return this;
        }

        public final void setSupportCode(String supportCode) {
            this.supportCode = supportCode;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final ResourceLocation getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(ResourceLocation location) {
            this.location = location;
            return this;
        }

        public final void setLocation(ResourceLocation location) {
            this.location = location;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(InstanceSnapshotState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getProgress() {
            return this.progress;
        }

        @Override
        public final Builder progress(String progress) {
            this.progress = progress;
            return this;
        }

        public final void setProgress(String progress) {
            this.progress = progress;
        }

        public final String getFromInstanceName() {
            return this.fromInstanceName;
        }

        @Override
        public final Builder fromInstanceName(String fromInstanceName) {
            this.fromInstanceName = fromInstanceName;
            return this;
        }

        public final void setFromInstanceName(String fromInstanceName) {
            this.fromInstanceName = fromInstanceName;
        }

        public final String getFromInstanceArn() {
            return this.fromInstanceArn;
        }

        @Override
        public final Builder fromInstanceArn(String fromInstanceArn) {
            this.fromInstanceArn = fromInstanceArn;
            return this;
        }

        public final void setFromInstanceArn(String fromInstanceArn) {
            this.fromInstanceArn = fromInstanceArn;
        }

        public final String getFromBlueprintId() {
            return this.fromBlueprintId;
        }

        @Override
        public final Builder fromBlueprintId(String fromBlueprintId) {
            this.fromBlueprintId = fromBlueprintId;
            return this;
        }

        public final void setFromBlueprintId(String fromBlueprintId) {
            this.fromBlueprintId = fromBlueprintId;
        }

        public final String getFromBundleId() {
            return this.fromBundleId;
        }

        @Override
        public final Builder fromBundleId(String fromBundleId) {
            this.fromBundleId = fromBundleId;
            return this;
        }

        public final void setFromBundleId(String fromBundleId) {
            this.fromBundleId = fromBundleId;
        }

        public final Integer getSizeInGb() {
            return this.sizeInGb;
        }

        @Override
        public final Builder sizeInGb(Integer sizeInGb) {
            this.sizeInGb = sizeInGb;
            return this;
        }

        public final void setSizeInGb(Integer sizeInGb) {
            this.sizeInGb = sizeInGb;
        }

        public InstanceSnapshot build() {
            return new InstanceSnapshot(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceSnapshot> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder supportCode(String var1);

        public Builder createdAt(Instant var1);

        public Builder location(ResourceLocation var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder state(String var1);

        public Builder state(InstanceSnapshotState var1);

        public Builder progress(String var1);

        public Builder fromInstanceName(String var1);

        public Builder fromInstanceArn(String var1);

        public Builder fromBlueprintId(String var1);

        public Builder fromBundleId(String var1);

        public Builder sizeInGb(Integer var1);
    }
}

