/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.lightsail.model.Operation;
import software.amazon.awssdk.services.lightsail.model.OperationListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetOperationsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetOperationsResponse> {
    private final List<Operation> operations;
    private final String nextPageToken;

    private GetOperationsResponse(BuilderImpl builder) {
        this.operations = builder.operations;
        this.nextPageToken = builder.nextPageToken;
    }

    public List<Operation> operations() {
        return this.operations;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.operations() == null ? 0 : this.operations().hashCode());
        hashCode = 31 * hashCode + (this.nextPageToken() == null ? 0 : this.nextPageToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOperationsResponse)) {
            return false;
        }
        GetOperationsResponse other = (GetOperationsResponse)((Object)obj);
        if (other.operations() == null ^ this.operations() == null) {
            return false;
        }
        if (other.operations() != null && !other.operations().equals(this.operations())) {
            return false;
        }
        if (other.nextPageToken() == null ^ this.nextPageToken() == null) {
            return false;
        }
        return other.nextPageToken() == null || other.nextPageToken().equals(this.nextPageToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.operations() != null) {
            sb.append("Operations: ").append(this.operations()).append(",");
        }
        if (this.nextPageToken() != null) {
            sb.append("NextPageToken: ").append(this.nextPageToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Operation> operations;
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOperationsResponse model) {
            this.setOperations(model.operations);
            this.setNextPageToken(model.nextPageToken);
        }

        public final Collection<Operation> getOperations() {
            return this.operations;
        }

        @Override
        public final Builder operations(Collection<Operation> operations) {
            this.operations = OperationListCopier.copy(operations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(Operation ... operations) {
            this.operations(Arrays.asList(operations));
            return this;
        }

        public final void setOperations(Collection<Operation> operations) {
            this.operations = OperationListCopier.copy(operations);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        public GetOperationsResponse build() {
            return new GetOperationsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetOperationsResponse> {
        public Builder operations(Collection<Operation> var1);

        public Builder operations(Operation ... var1);

        public Builder nextPageToken(String var1);
    }
}

