/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.lightsail.model.InstanceMetricName;
import software.amazon.awssdk.services.lightsail.model.MetricDatapoint;
import software.amazon.awssdk.services.lightsail.model.MetricDatapointListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetInstanceMetricDataResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetInstanceMetricDataResponse> {
    private final String metricName;
    private final List<MetricDatapoint> metricData;

    private GetInstanceMetricDataResponse(BuilderImpl builder) {
        this.metricName = builder.metricName;
        this.metricData = builder.metricData;
    }

    public String metricName() {
        return this.metricName;
    }

    public List<MetricDatapoint> metricData() {
        return this.metricData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.metricName() == null ? 0 : this.metricName().hashCode());
        hashCode = 31 * hashCode + (this.metricData() == null ? 0 : this.metricData().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInstanceMetricDataResponse)) {
            return false;
        }
        GetInstanceMetricDataResponse other = (GetInstanceMetricDataResponse)((Object)obj);
        if (other.metricName() == null ^ this.metricName() == null) {
            return false;
        }
        if (other.metricName() != null && !other.metricName().equals(this.metricName())) {
            return false;
        }
        if (other.metricData() == null ^ this.metricData() == null) {
            return false;
        }
        return other.metricData() == null || other.metricData().equals(this.metricData());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.metricName() != null) {
            sb.append("MetricName: ").append(this.metricName()).append(",");
        }
        if (this.metricData() != null) {
            sb.append("MetricData: ").append(this.metricData()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String metricName;
        private List<MetricDatapoint> metricData;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInstanceMetricDataResponse model) {
            this.setMetricName(model.metricName);
            this.setMetricData(model.metricData);
        }

        public final String getMetricName() {
            return this.metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        @Override
        public final Builder metricName(InstanceMetricName metricName) {
            this.metricName(metricName.toString());
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final Collection<MetricDatapoint> getMetricData() {
            return this.metricData;
        }

        @Override
        public final Builder metricData(Collection<MetricDatapoint> metricData) {
            this.metricData = MetricDatapointListCopier.copy(metricData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricData(MetricDatapoint ... metricData) {
            this.metricData(Arrays.asList(metricData));
            return this;
        }

        public final void setMetricData(Collection<MetricDatapoint> metricData) {
            this.metricData = MetricDatapointListCopier.copy(metricData);
        }

        public GetInstanceMetricDataResponse build() {
            return new GetInstanceMetricDataResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetInstanceMetricDataResponse> {
        public Builder metricName(String var1);

        public Builder metricName(InstanceMetricName var1);

        public Builder metricData(Collection<MetricDatapoint> var1);

        public Builder metricData(MetricDatapoint ... var1);
    }
}

