/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.time.Instant;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.model.InstanceHardware;
import software.amazon.awssdk.services.lightsail.model.InstanceNetworking;
import software.amazon.awssdk.services.lightsail.model.InstanceState;
import software.amazon.awssdk.services.lightsail.model.ResourceLocation;
import software.amazon.awssdk.services.lightsail.model.ResourceType;
import software.amazon.awssdk.services.lightsail.transform.InstanceMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Instance
implements StructuredPojo,
ToCopyableBuilder<Builder, Instance> {
    private final String name;
    private final String arn;
    private final String supportCode;
    private final Instant createdAt;
    private final ResourceLocation location;
    private final String resourceType;
    private final String blueprintId;
    private final String blueprintName;
    private final String bundleId;
    private final Boolean isStaticIp;
    private final String privateIpAddress;
    private final String publicIpAddress;
    private final String ipv6Address;
    private final InstanceHardware hardware;
    private final InstanceNetworking networking;
    private final InstanceState state;
    private final String username;
    private final String sshKeyName;

    private Instance(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.supportCode = builder.supportCode;
        this.createdAt = builder.createdAt;
        this.location = builder.location;
        this.resourceType = builder.resourceType;
        this.blueprintId = builder.blueprintId;
        this.blueprintName = builder.blueprintName;
        this.bundleId = builder.bundleId;
        this.isStaticIp = builder.isStaticIp;
        this.privateIpAddress = builder.privateIpAddress;
        this.publicIpAddress = builder.publicIpAddress;
        this.ipv6Address = builder.ipv6Address;
        this.hardware = builder.hardware;
        this.networking = builder.networking;
        this.state = builder.state;
        this.username = builder.username;
        this.sshKeyName = builder.sshKeyName;
    }

    public String name() {
        return this.name;
    }

    public String arn() {
        return this.arn;
    }

    public String supportCode() {
        return this.supportCode;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public ResourceLocation location() {
        return this.location;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public String blueprintId() {
        return this.blueprintId;
    }

    public String blueprintName() {
        return this.blueprintName;
    }

    public String bundleId() {
        return this.bundleId;
    }

    public Boolean isStaticIp() {
        return this.isStaticIp;
    }

    public String privateIpAddress() {
        return this.privateIpAddress;
    }

    public String publicIpAddress() {
        return this.publicIpAddress;
    }

    public String ipv6Address() {
        return this.ipv6Address;
    }

    public InstanceHardware hardware() {
        return this.hardware;
    }

    public InstanceNetworking networking() {
        return this.networking;
    }

    public InstanceState state() {
        return this.state;
    }

    public String username() {
        return this.username;
    }

    public String sshKeyName() {
        return this.sshKeyName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.arn() == null ? 0 : this.arn().hashCode());
        hashCode = 31 * hashCode + (this.supportCode() == null ? 0 : this.supportCode().hashCode());
        hashCode = 31 * hashCode + (this.createdAt() == null ? 0 : this.createdAt().hashCode());
        hashCode = 31 * hashCode + (this.location() == null ? 0 : this.location().hashCode());
        hashCode = 31 * hashCode + (this.resourceType() == null ? 0 : this.resourceType().hashCode());
        hashCode = 31 * hashCode + (this.blueprintId() == null ? 0 : this.blueprintId().hashCode());
        hashCode = 31 * hashCode + (this.blueprintName() == null ? 0 : this.blueprintName().hashCode());
        hashCode = 31 * hashCode + (this.bundleId() == null ? 0 : this.bundleId().hashCode());
        hashCode = 31 * hashCode + (this.isStaticIp() == null ? 0 : this.isStaticIp().hashCode());
        hashCode = 31 * hashCode + (this.privateIpAddress() == null ? 0 : this.privateIpAddress().hashCode());
        hashCode = 31 * hashCode + (this.publicIpAddress() == null ? 0 : this.publicIpAddress().hashCode());
        hashCode = 31 * hashCode + (this.ipv6Address() == null ? 0 : this.ipv6Address().hashCode());
        hashCode = 31 * hashCode + (this.hardware() == null ? 0 : this.hardware().hashCode());
        hashCode = 31 * hashCode + (this.networking() == null ? 0 : this.networking().hashCode());
        hashCode = 31 * hashCode + (this.state() == null ? 0 : this.state().hashCode());
        hashCode = 31 * hashCode + (this.username() == null ? 0 : this.username().hashCode());
        hashCode = 31 * hashCode + (this.sshKeyName() == null ? 0 : this.sshKeyName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Instance)) {
            return false;
        }
        Instance other = (Instance)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.supportCode() == null ^ this.supportCode() == null) {
            return false;
        }
        if (other.supportCode() != null && !other.supportCode().equals(this.supportCode())) {
            return false;
        }
        if (other.createdAt() == null ^ this.createdAt() == null) {
            return false;
        }
        if (other.createdAt() != null && !other.createdAt().equals(this.createdAt())) {
            return false;
        }
        if (other.location() == null ^ this.location() == null) {
            return false;
        }
        if (other.location() != null && !other.location().equals(this.location())) {
            return false;
        }
        if (other.resourceType() == null ^ this.resourceType() == null) {
            return false;
        }
        if (other.resourceType() != null && !other.resourceType().equals(this.resourceType())) {
            return false;
        }
        if (other.blueprintId() == null ^ this.blueprintId() == null) {
            return false;
        }
        if (other.blueprintId() != null && !other.blueprintId().equals(this.blueprintId())) {
            return false;
        }
        if (other.blueprintName() == null ^ this.blueprintName() == null) {
            return false;
        }
        if (other.blueprintName() != null && !other.blueprintName().equals(this.blueprintName())) {
            return false;
        }
        if (other.bundleId() == null ^ this.bundleId() == null) {
            return false;
        }
        if (other.bundleId() != null && !other.bundleId().equals(this.bundleId())) {
            return false;
        }
        if (other.isStaticIp() == null ^ this.isStaticIp() == null) {
            return false;
        }
        if (other.isStaticIp() != null && !other.isStaticIp().equals(this.isStaticIp())) {
            return false;
        }
        if (other.privateIpAddress() == null ^ this.privateIpAddress() == null) {
            return false;
        }
        if (other.privateIpAddress() != null && !other.privateIpAddress().equals(this.privateIpAddress())) {
            return false;
        }
        if (other.publicIpAddress() == null ^ this.publicIpAddress() == null) {
            return false;
        }
        if (other.publicIpAddress() != null && !other.publicIpAddress().equals(this.publicIpAddress())) {
            return false;
        }
        if (other.ipv6Address() == null ^ this.ipv6Address() == null) {
            return false;
        }
        if (other.ipv6Address() != null && !other.ipv6Address().equals(this.ipv6Address())) {
            return false;
        }
        if (other.hardware() == null ^ this.hardware() == null) {
            return false;
        }
        if (other.hardware() != null && !other.hardware().equals(this.hardware())) {
            return false;
        }
        if (other.networking() == null ^ this.networking() == null) {
            return false;
        }
        if (other.networking() != null && !other.networking().equals(this.networking())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.username() == null ^ this.username() == null) {
            return false;
        }
        if (other.username() != null && !other.username().equals(this.username())) {
            return false;
        }
        if (other.sshKeyName() == null ^ this.sshKeyName() == null) {
            return false;
        }
        return other.sshKeyName() == null || other.sshKeyName().equals(this.sshKeyName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.arn() != null) {
            sb.append("Arn: ").append(this.arn()).append(",");
        }
        if (this.supportCode() != null) {
            sb.append("SupportCode: ").append(this.supportCode()).append(",");
        }
        if (this.createdAt() != null) {
            sb.append("CreatedAt: ").append(this.createdAt()).append(",");
        }
        if (this.location() != null) {
            sb.append("Location: ").append(this.location()).append(",");
        }
        if (this.resourceType() != null) {
            sb.append("ResourceType: ").append(this.resourceType()).append(",");
        }
        if (this.blueprintId() != null) {
            sb.append("BlueprintId: ").append(this.blueprintId()).append(",");
        }
        if (this.blueprintName() != null) {
            sb.append("BlueprintName: ").append(this.blueprintName()).append(",");
        }
        if (this.bundleId() != null) {
            sb.append("BundleId: ").append(this.bundleId()).append(",");
        }
        if (this.isStaticIp() != null) {
            sb.append("IsStaticIp: ").append(this.isStaticIp()).append(",");
        }
        if (this.privateIpAddress() != null) {
            sb.append("PrivateIpAddress: ").append(this.privateIpAddress()).append(",");
        }
        if (this.publicIpAddress() != null) {
            sb.append("PublicIpAddress: ").append(this.publicIpAddress()).append(",");
        }
        if (this.ipv6Address() != null) {
            sb.append("Ipv6Address: ").append(this.ipv6Address()).append(",");
        }
        if (this.hardware() != null) {
            sb.append("Hardware: ").append(this.hardware()).append(",");
        }
        if (this.networking() != null) {
            sb.append("Networking: ").append(this.networking()).append(",");
        }
        if (this.state() != null) {
            sb.append("State: ").append(this.state()).append(",");
        }
        if (this.username() != null) {
            sb.append("Username: ").append(this.username()).append(",");
        }
        if (this.sshKeyName() != null) {
            sb.append("SshKeyName: ").append(this.sshKeyName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private String supportCode;
        private Instant createdAt;
        private ResourceLocation location;
        private String resourceType;
        private String blueprintId;
        private String blueprintName;
        private String bundleId;
        private Boolean isStaticIp;
        private String privateIpAddress;
        private String publicIpAddress;
        private String ipv6Address;
        private InstanceHardware hardware;
        private InstanceNetworking networking;
        private InstanceState state;
        private String username;
        private String sshKeyName;

        private BuilderImpl() {
        }

        private BuilderImpl(Instance model) {
            this.setName(model.name);
            this.setArn(model.arn);
            this.setSupportCode(model.supportCode);
            this.setCreatedAt(model.createdAt);
            this.setLocation(model.location);
            this.setResourceType(model.resourceType);
            this.setBlueprintId(model.blueprintId);
            this.setBlueprintName(model.blueprintName);
            this.setBundleId(model.bundleId);
            this.setIsStaticIp(model.isStaticIp);
            this.setPrivateIpAddress(model.privateIpAddress);
            this.setPublicIpAddress(model.publicIpAddress);
            this.setIpv6Address(model.ipv6Address);
            this.setHardware(model.hardware);
            this.setNetworking(model.networking);
            this.setState(model.state);
            this.setUsername(model.username);
            this.setSshKeyName(model.sshKeyName);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getSupportCode() {
            return this.supportCode;
        }

        @Override
        public final Builder supportCode(String supportCode) {
            this.supportCode = supportCode;
            return this;
        }

        public final void setSupportCode(String supportCode) {
            this.supportCode = supportCode;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final ResourceLocation getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(ResourceLocation location) {
            this.location = location;
            return this;
        }

        public final void setLocation(ResourceLocation location) {
            this.location = location;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getBlueprintId() {
            return this.blueprintId;
        }

        @Override
        public final Builder blueprintId(String blueprintId) {
            this.blueprintId = blueprintId;
            return this;
        }

        public final void setBlueprintId(String blueprintId) {
            this.blueprintId = blueprintId;
        }

        public final String getBlueprintName() {
            return this.blueprintName;
        }

        @Override
        public final Builder blueprintName(String blueprintName) {
            this.blueprintName = blueprintName;
            return this;
        }

        public final void setBlueprintName(String blueprintName) {
            this.blueprintName = blueprintName;
        }

        public final String getBundleId() {
            return this.bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        public final Boolean getIsStaticIp() {
            return this.isStaticIp;
        }

        @Override
        public final Builder isStaticIp(Boolean isStaticIp) {
            this.isStaticIp = isStaticIp;
            return this;
        }

        public final void setIsStaticIp(Boolean isStaticIp) {
            this.isStaticIp = isStaticIp;
        }

        public final String getPrivateIpAddress() {
            return this.privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        public final String getPublicIpAddress() {
            return this.publicIpAddress;
        }

        @Override
        public final Builder publicIpAddress(String publicIpAddress) {
            this.publicIpAddress = publicIpAddress;
            return this;
        }

        public final void setPublicIpAddress(String publicIpAddress) {
            this.publicIpAddress = publicIpAddress;
        }

        public final String getIpv6Address() {
            return this.ipv6Address;
        }

        @Override
        public final Builder ipv6Address(String ipv6Address) {
            this.ipv6Address = ipv6Address;
            return this;
        }

        public final void setIpv6Address(String ipv6Address) {
            this.ipv6Address = ipv6Address;
        }

        public final InstanceHardware getHardware() {
            return this.hardware;
        }

        @Override
        public final Builder hardware(InstanceHardware hardware) {
            this.hardware = hardware;
            return this;
        }

        public final void setHardware(InstanceHardware hardware) {
            this.hardware = hardware;
        }

        public final InstanceNetworking getNetworking() {
            return this.networking;
        }

        @Override
        public final Builder networking(InstanceNetworking networking) {
            this.networking = networking;
            return this;
        }

        public final void setNetworking(InstanceNetworking networking) {
            this.networking = networking;
        }

        public final InstanceState getState() {
            return this.state;
        }

        @Override
        public final Builder state(InstanceState state) {
            this.state = state;
            return this;
        }

        public final void setState(InstanceState state) {
            this.state = state;
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final String getSshKeyName() {
            return this.sshKeyName;
        }

        @Override
        public final Builder sshKeyName(String sshKeyName) {
            this.sshKeyName = sshKeyName;
            return this;
        }

        public final void setSshKeyName(String sshKeyName) {
            this.sshKeyName = sshKeyName;
        }

        public Instance build() {
            return new Instance(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Instance> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder supportCode(String var1);

        public Builder createdAt(Instant var1);

        public Builder location(ResourceLocation var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder blueprintId(String var1);

        public Builder blueprintName(String var1);

        public Builder bundleId(String var1);

        public Builder isStaticIp(Boolean var1);

        public Builder privateIpAddress(String var1);

        public Builder publicIpAddress(String var1);

        public Builder ipv6Address(String var1);

        public Builder hardware(InstanceHardware var1);

        public Builder networking(InstanceNetworking var1);

        public Builder state(InstanceState var1);

        public Builder username(String var1);

        public Builder sshKeyName(String var1);
    }
}

