/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.lightsail.model.Operation;
import software.amazon.awssdk.services.lightsail.transform.ResourceLocationUnmarshaller;

public class OperationUnmarshaller
implements Unmarshaller<Operation, JsonUnmarshallerContext> {
    private static OperationUnmarshaller INSTANCE;

    public Operation unmarshall(JsonUnmarshallerContext context) throws Exception {
        Operation.Builder operationBuilder = Operation.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("id", targetDepth)) {
                    context.nextToken();
                    operationBuilder.id((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("resourceName", targetDepth)) {
                    context.nextToken();
                    operationBuilder.resourceName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("resourceType", targetDepth)) {
                    context.nextToken();
                    operationBuilder.resourceType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("createdAt", targetDepth)) {
                    context.nextToken();
                    operationBuilder.createdAt((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("location", targetDepth)) {
                    context.nextToken();
                    operationBuilder.location(ResourceLocationUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("isTerminal", targetDepth)) {
                    context.nextToken();
                    operationBuilder.isTerminal((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("operationDetails", targetDepth)) {
                    context.nextToken();
                    operationBuilder.operationDetails((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("operationType", targetDepth)) {
                    context.nextToken();
                    operationBuilder.operationType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("status", targetDepth)) {
                    context.nextToken();
                    operationBuilder.status((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("statusChangedAt", targetDepth)) {
                    context.nextToken();
                    operationBuilder.statusChangedAt((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("errorCode", targetDepth)) {
                    context.nextToken();
                    operationBuilder.errorCode((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("errorDetails", targetDepth)) {
                    context.nextToken();
                    operationBuilder.errorDetails((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Operation)operationBuilder.build();
    }

    public static OperationUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new OperationUnmarshaller();
        }
        return INSTANCE;
    }
}

