/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.transform;

import java.time.Instant;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lightsail.model.MetricDatapoint;

@SdkInternalApi
public class MetricDatapointMarshaller {
    private static final MarshallingInfo<Double> AVERAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("average").build();
    private static final MarshallingInfo<Double> MAXIMUM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maximum").build();
    private static final MarshallingInfo<Double> MINIMUM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("minimum").build();
    private static final MarshallingInfo<Double> SAMPLECOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sampleCount").build();
    private static final MarshallingInfo<Double> SUM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sum").build();
    private static final MarshallingInfo<Instant> TIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timestamp").build();
    private static final MarshallingInfo<String> UNIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("unit").build();
    private static final MetricDatapointMarshaller instance = new MetricDatapointMarshaller();

    public static MetricDatapointMarshaller getInstance() {
        return instance;
    }

    public void marshall(MetricDatapoint metricDatapoint, ProtocolMarshaller protocolMarshaller) {
        if (metricDatapoint == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)metricDatapoint.average(), AVERAGE_BINDING);
            protocolMarshaller.marshall((Object)metricDatapoint.maximum(), MAXIMUM_BINDING);
            protocolMarshaller.marshall((Object)metricDatapoint.minimum(), MINIMUM_BINDING);
            protocolMarshaller.marshall((Object)metricDatapoint.sampleCount(), SAMPLECOUNT_BINDING);
            protocolMarshaller.marshall((Object)metricDatapoint.sum(), SUM_BINDING);
            protocolMarshaller.marshall((Object)metricDatapoint.timestamp(), TIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)metricDatapoint.unit(), UNIT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

