/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.lightsail.model.PortInfo;
import software.amazon.awssdk.services.lightsail.model.PortInfoListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutInstancePublicPortsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PutInstancePublicPortsRequest> {
    private final List<PortInfo> portInfos;
    private final String instanceName;

    private PutInstancePublicPortsRequest(BuilderImpl builder) {
        this.portInfos = builder.portInfos;
        this.instanceName = builder.instanceName;
    }

    public List<PortInfo> portInfos() {
        return this.portInfos;
    }

    public String instanceName() {
        return this.instanceName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.portInfos() == null ? 0 : this.portInfos().hashCode());
        hashCode = 31 * hashCode + (this.instanceName() == null ? 0 : this.instanceName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutInstancePublicPortsRequest)) {
            return false;
        }
        PutInstancePublicPortsRequest other = (PutInstancePublicPortsRequest)((Object)obj);
        if (other.portInfos() == null ^ this.portInfos() == null) {
            return false;
        }
        if (other.portInfos() != null && !other.portInfos().equals(this.portInfos())) {
            return false;
        }
        if (other.instanceName() == null ^ this.instanceName() == null) {
            return false;
        }
        return other.instanceName() == null || other.instanceName().equals(this.instanceName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.portInfos() != null) {
            sb.append("PortInfos: ").append(this.portInfos()).append(",");
        }
        if (this.instanceName() != null) {
            sb.append("InstanceName: ").append(this.instanceName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<PortInfo> portInfos;
        private String instanceName;

        private BuilderImpl() {
        }

        private BuilderImpl(PutInstancePublicPortsRequest model) {
            this.setPortInfos(model.portInfos);
            this.setInstanceName(model.instanceName);
        }

        public final Collection<PortInfo> getPortInfos() {
            return this.portInfos;
        }

        @Override
        public final Builder portInfos(Collection<PortInfo> portInfos) {
            this.portInfos = PortInfoListCopier.copy(portInfos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portInfos(PortInfo ... portInfos) {
            this.portInfos(Arrays.asList(portInfos));
            return this;
        }

        public final void setPortInfos(Collection<PortInfo> portInfos) {
            this.portInfos = PortInfoListCopier.copy(portInfos);
        }

        @SafeVarargs
        public final void setPortInfos(PortInfo ... portInfos) {
            this.portInfos(Arrays.asList(portInfos));
        }

        public final String getInstanceName() {
            return this.instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public PutInstancePublicPortsRequest build() {
            return new PutInstancePublicPortsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutInstancePublicPortsRequest> {
        public Builder portInfos(Collection<PortInfo> var1);

        public Builder portInfos(PortInfo ... var1);

        public Builder instanceName(String var1);
    }
}

