/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.stream.Stream;
import software.amazon.awssdk.util.StringUtils;

public enum OperationType {
    DeleteInstance("DeleteInstance"),
    CreateInstance("CreateInstance"),
    StopInstance("StopInstance"),
    StartInstance("StartInstance"),
    RebootInstance("RebootInstance"),
    OpenInstancePublicPorts("OpenInstancePublicPorts"),
    PutInstancePublicPorts("PutInstancePublicPorts"),
    CloseInstancePublicPorts("CloseInstancePublicPorts"),
    AllocateStaticIp("AllocateStaticIp"),
    ReleaseStaticIp("ReleaseStaticIp"),
    AttachStaticIp("AttachStaticIp"),
    DetachStaticIp("DetachStaticIp"),
    UpdateDomainEntry("UpdateDomainEntry"),
    DeleteDomainEntry("DeleteDomainEntry"),
    CreateDomain("CreateDomain"),
    DeleteDomain("DeleteDomain"),
    CreateInstanceSnapshot("CreateInstanceSnapshot"),
    DeleteInstanceSnapshot("DeleteInstanceSnapshot"),
    CreateInstancesFromSnapshot("CreateInstancesFromSnapshot");

    private final String value;

    private OperationType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public static OperationType fromValue(String value) {
        if (StringUtils.isNullOrEmpty((String)value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }
        return Stream.of(OperationType.values()).filter(e -> e.toString().equals(value)).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot create enum from " + value + " value!"));
    }
}

