/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.model.Disk;
import software.amazon.awssdk.services.lightsail.model.DiskListCopier;
import software.amazon.awssdk.services.lightsail.transform.InstanceHardwareMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceHardware
implements StructuredPojo,
ToCopyableBuilder<Builder, InstanceHardware> {
    private final Integer cpuCount;
    private final List<Disk> disks;
    private final Float ramSizeInGb;

    private InstanceHardware(BuilderImpl builder) {
        this.cpuCount = builder.cpuCount;
        this.disks = builder.disks;
        this.ramSizeInGb = builder.ramSizeInGb;
    }

    public Integer cpuCount() {
        return this.cpuCount;
    }

    public List<Disk> disks() {
        return this.disks;
    }

    public Float ramSizeInGb() {
        return this.ramSizeInGb;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.cpuCount() == null ? 0 : this.cpuCount().hashCode());
        hashCode = 31 * hashCode + (this.disks() == null ? 0 : this.disks().hashCode());
        hashCode = 31 * hashCode + (this.ramSizeInGb() == null ? 0 : this.ramSizeInGb().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceHardware)) {
            return false;
        }
        InstanceHardware other = (InstanceHardware)obj;
        if (other.cpuCount() == null ^ this.cpuCount() == null) {
            return false;
        }
        if (other.cpuCount() != null && !other.cpuCount().equals(this.cpuCount())) {
            return false;
        }
        if (other.disks() == null ^ this.disks() == null) {
            return false;
        }
        if (other.disks() != null && !other.disks().equals(this.disks())) {
            return false;
        }
        if (other.ramSizeInGb() == null ^ this.ramSizeInGb() == null) {
            return false;
        }
        return other.ramSizeInGb() == null || other.ramSizeInGb().equals(this.ramSizeInGb());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.cpuCount() != null) {
            sb.append("CpuCount: ").append(this.cpuCount()).append(",");
        }
        if (this.disks() != null) {
            sb.append("Disks: ").append(this.disks()).append(",");
        }
        if (this.ramSizeInGb() != null) {
            sb.append("RamSizeInGb: ").append(this.ramSizeInGb()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceHardwareMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Integer cpuCount;
        private List<Disk> disks;
        private Float ramSizeInGb;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceHardware model) {
            this.setCpuCount(model.cpuCount);
            this.setDisks(model.disks);
            this.setRamSizeInGb(model.ramSizeInGb);
        }

        public final Integer getCpuCount() {
            return this.cpuCount;
        }

        @Override
        public final Builder cpuCount(Integer cpuCount) {
            this.cpuCount = cpuCount;
            return this;
        }

        public final void setCpuCount(Integer cpuCount) {
            this.cpuCount = cpuCount;
        }

        public final Collection<Disk> getDisks() {
            return this.disks;
        }

        @Override
        public final Builder disks(Collection<Disk> disks) {
            this.disks = DiskListCopier.copy(disks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder disks(Disk ... disks) {
            this.disks(Arrays.asList(disks));
            return this;
        }

        public final void setDisks(Collection<Disk> disks) {
            this.disks = DiskListCopier.copy(disks);
        }

        @SafeVarargs
        public final void setDisks(Disk ... disks) {
            this.disks(Arrays.asList(disks));
        }

        public final Float getRamSizeInGb() {
            return this.ramSizeInGb;
        }

        @Override
        public final Builder ramSizeInGb(Float ramSizeInGb) {
            this.ramSizeInGb = ramSizeInGb;
            return this;
        }

        public final void setRamSizeInGb(Float ramSizeInGb) {
            this.ramSizeInGb = ramSizeInGb;
        }

        public InstanceHardware build() {
            return new InstanceHardware(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceHardware> {
        public Builder cpuCount(Integer var1);

        public Builder disks(Collection<Disk> var1);

        public Builder disks(Disk ... var1);

        public Builder ramSizeInGb(Float var1);
    }
}

