/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lightsail.model.MetricDatapoint;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class MetricDatapointMarshaller {
    private static final MarshallingInfo<Double> AVERAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("average").isBinary(false).build();
    private static final MarshallingInfo<Double> MAXIMUM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maximum").isBinary(false).build();
    private static final MarshallingInfo<Double> MINIMUM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("minimum").isBinary(false).build();
    private static final MarshallingInfo<Double> SAMPLECOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sampleCount").isBinary(false).build();
    private static final MarshallingInfo<Double> SUM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sum").isBinary(false).build();
    private static final MarshallingInfo<Instant> TIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timestamp").isBinary(false).build();
    private static final MarshallingInfo<String> UNIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("unit").isBinary(false).build();
    private static final MetricDatapointMarshaller INSTANCE = new MetricDatapointMarshaller();

    private MetricDatapointMarshaller() {
    }

    public static MetricDatapointMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(MetricDatapoint metricDatapoint, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)metricDatapoint, (String)"metricDatapoint");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)metricDatapoint.average(), AVERAGE_BINDING);
            protocolMarshaller.marshall((Object)metricDatapoint.maximum(), MAXIMUM_BINDING);
            protocolMarshaller.marshall((Object)metricDatapoint.minimum(), MINIMUM_BINDING);
            protocolMarshaller.marshall((Object)metricDatapoint.sampleCount(), SAMPLECOUNT_BINDING);
            protocolMarshaller.marshall((Object)metricDatapoint.sum(), SUM_BINDING);
            protocolMarshaller.marshall((Object)metricDatapoint.timestamp(), TIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)metricDatapoint.unitAsString(), UNIT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

