/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lightsail.model.InstanceHardware;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class InstanceHardwareMarshaller {
    private static final MarshallingInfo<Integer> CPUCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cpuCount").isBinary(false).build();
    private static final MarshallingInfo<List> DISKS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("disks").isBinary(false).build();
    private static final MarshallingInfo<Float> RAMSIZEINGB_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ramSizeInGb").isBinary(false).build();
    private static final InstanceHardwareMarshaller INSTANCE = new InstanceHardwareMarshaller();

    private InstanceHardwareMarshaller() {
    }

    public static InstanceHardwareMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InstanceHardware instanceHardware, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)instanceHardware, (String)"instanceHardware");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)instanceHardware.cpuCount(), CPUCOUNT_BINDING);
            protocolMarshaller.marshall(instanceHardware.disks(), DISKS_BINDING);
            protocolMarshaller.marshall((Object)instanceHardware.ramSizeInGb(), RAMSIZEINGB_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

