/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.lightsail.model.InstanceState;

public class InstanceStateUnmarshaller
implements Unmarshaller<InstanceState, JsonUnmarshallerContext> {
    private static final InstanceStateUnmarshaller INSTANCE = new InstanceStateUnmarshaller();

    public InstanceState unmarshall(JsonUnmarshallerContext context) throws Exception {
        InstanceState.Builder instanceStateBuilder = InstanceState.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("code", targetDepth)) {
                    context.nextToken();
                    instanceStateBuilder.code((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    instanceStateBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (InstanceState)instanceStateBuilder.build();
    }

    public static InstanceStateUnmarshaller getInstance() {
        return INSTANCE;
    }
}

