/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lightsail.model.GetBundlesRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GetBundlesRequestModelMarshaller {
    private static final MarshallingInfo<Boolean> INCLUDEINACTIVE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("includeInactive").isBinary(false).build();
    private static final MarshallingInfo<String> PAGETOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pageToken").isBinary(false).build();
    private static final GetBundlesRequestModelMarshaller INSTANCE = new GetBundlesRequestModelMarshaller();

    private GetBundlesRequestModelMarshaller() {
    }

    public static GetBundlesRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GetBundlesRequest getBundlesRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)getBundlesRequest), (String)"getBundlesRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)getBundlesRequest.includeInactive(), INCLUDEINACTIVE_BINDING);
            protocolMarshaller.marshall((Object)getBundlesRequest.pageToken(), PAGETOKEN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

