/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lightsail.model.DomainEntry;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DomainEntryMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<String> TARGET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("target").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").isBinary(false).build();
    private static final MarshallingInfo<Map> OPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("options").isBinary(false).build();
    private static final DomainEntryMarshaller INSTANCE = new DomainEntryMarshaller();

    private DomainEntryMarshaller() {
    }

    public static DomainEntryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DomainEntry domainEntry, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)domainEntry, (String)"domainEntry");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)domainEntry.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)domainEntry.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)domainEntry.target(), TARGET_BINDING);
            protocolMarshaller.marshall((Object)domainEntry.type(), TYPE_BINDING);
            protocolMarshaller.marshall(domainEntry.options(), OPTIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

