/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lightsail.model.CreateInstancesFromSnapshotRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateInstancesFromSnapshotRequestModelMarshaller {
    private static final MarshallingInfo<List> INSTANCENAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("instanceNames").isBinary(false).build();
    private static final MarshallingInfo<Map> ATTACHEDDISKMAPPING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("attachedDiskMapping").isBinary(false).build();
    private static final MarshallingInfo<String> AVAILABILITYZONE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("availabilityZone").isBinary(false).build();
    private static final MarshallingInfo<String> INSTANCESNAPSHOTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("instanceSnapshotName").isBinary(false).build();
    private static final MarshallingInfo<String> BUNDLEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bundleId").isBinary(false).build();
    private static final MarshallingInfo<String> USERDATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("userData").isBinary(false).build();
    private static final MarshallingInfo<String> KEYPAIRNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("keyPairName").isBinary(false).build();
    private static final CreateInstancesFromSnapshotRequestModelMarshaller INSTANCE = new CreateInstancesFromSnapshotRequestModelMarshaller();

    private CreateInstancesFromSnapshotRequestModelMarshaller() {
    }

    public static CreateInstancesFromSnapshotRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateInstancesFromSnapshotRequest createInstancesFromSnapshotRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createInstancesFromSnapshotRequest), (String)"createInstancesFromSnapshotRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(createInstancesFromSnapshotRequest.instanceNames(), INSTANCENAMES_BINDING);
            protocolMarshaller.marshall(createInstancesFromSnapshotRequest.attachedDiskMapping(), ATTACHEDDISKMAPPING_BINDING);
            protocolMarshaller.marshall((Object)createInstancesFromSnapshotRequest.availabilityZone(), AVAILABILITYZONE_BINDING);
            protocolMarshaller.marshall((Object)createInstancesFromSnapshotRequest.instanceSnapshotName(), INSTANCESNAPSHOTNAME_BINDING);
            protocolMarshaller.marshall((Object)createInstancesFromSnapshotRequest.bundleId(), BUNDLEID_BINDING);
            protocolMarshaller.marshall((Object)createInstancesFromSnapshotRequest.userData(), USERDATA_BINDING);
            protocolMarshaller.marshall((Object)createInstancesFromSnapshotRequest.keyPairName(), KEYPAIRNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

