/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.lightsail.model.LightsailResponse;
import software.amazon.awssdk.services.lightsail.model.Region;
import software.amazon.awssdk.services.lightsail.model.RegionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetRegionsResponse
extends LightsailResponse
implements ToCopyableBuilder<Builder, GetRegionsResponse> {
    private final List<Region> regions;

    private GetRegionsResponse(BuilderImpl builder) {
        super(builder);
        this.regions = builder.regions;
    }

    public List<Region> regions() {
        return this.regions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.regions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRegionsResponse)) {
            return false;
        }
        GetRegionsResponse other = (GetRegionsResponse)((Object)obj);
        return Objects.equals(this.regions(), other.regions());
    }

    public String toString() {
        return ToString.builder((String)"GetRegionsResponse").add("Regions", this.regions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "regions": {
                return Optional.of(clazz.cast(this.regions()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends LightsailResponse.BuilderImpl
    implements Builder {
        private List<Region> regions;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRegionsResponse model) {
            super(model);
            this.regions(model.regions);
        }

        public final Collection<Region.Builder> getRegions() {
            return this.regions != null ? (Collection)this.regions.stream().map(Region::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder regions(Collection<Region> regions) {
            this.regions = RegionListCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(Region ... regions) {
            this.regions(Arrays.asList(regions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(Consumer<Region.Builder> ... regions) {
            this.regions(Stream.of(regions).map(c -> (Region)((Region.Builder)Region.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRegions(Collection<Region.BuilderImpl> regions) {
            this.regions = RegionListCopier.copyFromBuilder(regions);
        }

        @Override
        public GetRegionsResponse build() {
            return new GetRegionsResponse(this);
        }
    }

    public static interface Builder
    extends LightsailResponse.Builder,
    CopyableBuilder<Builder, GetRegionsResponse> {
        public Builder regions(Collection<Region> var1);

        public Builder regions(Region ... var1);

        public Builder regions(Consumer<Region.Builder> ... var1);
    }
}

