/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.lightsail.model.InstanceMetricName;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.services.lightsail.model.MetricStatistic;
import software.amazon.awssdk.services.lightsail.model.MetricStatisticListCopier;
import software.amazon.awssdk.services.lightsail.model.MetricUnit;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetInstanceMetricDataRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, GetInstanceMetricDataRequest> {
    private final String instanceName;
    private final String metricName;
    private final Integer period;
    private final Instant startTime;
    private final Instant endTime;
    private final String unit;
    private final List<String> statistics;

    private GetInstanceMetricDataRequest(BuilderImpl builder) {
        super(builder);
        this.instanceName = builder.instanceName;
        this.metricName = builder.metricName;
        this.period = builder.period;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.unit = builder.unit;
        this.statistics = builder.statistics;
    }

    public String instanceName() {
        return this.instanceName;
    }

    public InstanceMetricName metricName() {
        return InstanceMetricName.fromValue(this.metricName);
    }

    public String metricNameAsString() {
        return this.metricName;
    }

    public Integer period() {
        return this.period;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public MetricUnit unit() {
        return MetricUnit.fromValue(this.unit);
    }

    public String unitAsString() {
        return this.unit;
    }

    public List<MetricStatistic> statistics() {
        return TypeConverter.convert(this.statistics, MetricStatistic::fromValue);
    }

    public List<String> statisticsAsStrings() {
        return this.statistics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.period());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.unitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statisticsAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInstanceMetricDataRequest)) {
            return false;
        }
        GetInstanceMetricDataRequest other = (GetInstanceMetricDataRequest)((Object)obj);
        return Objects.equals(this.instanceName(), other.instanceName()) && Objects.equals(this.metricNameAsString(), other.metricNameAsString()) && Objects.equals(this.period(), other.period()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.unitAsString(), other.unitAsString()) && Objects.equals(this.statisticsAsStrings(), other.statisticsAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"GetInstanceMetricDataRequest").add("InstanceName", (Object)this.instanceName()).add("MetricName", (Object)this.metricNameAsString()).add("Period", (Object)this.period()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("Unit", (Object)this.unitAsString()).add("Statistics", this.statisticsAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceName": {
                return Optional.of(clazz.cast(this.instanceName()));
            }
            case "metricName": {
                return Optional.of(clazz.cast(this.metricNameAsString()));
            }
            case "period": {
                return Optional.of(clazz.cast(this.period()));
            }
            case "startTime": {
                return Optional.of(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.of(clazz.cast(this.endTime()));
            }
            case "unit": {
                return Optional.of(clazz.cast(this.unitAsString()));
            }
            case "statistics": {
                return Optional.of(clazz.cast(this.statisticsAsStrings()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private String instanceName;
        private String metricName;
        private Integer period;
        private Instant startTime;
        private Instant endTime;
        private String unit;
        private List<String> statistics;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInstanceMetricDataRequest model) {
            super(model);
            this.instanceName(model.instanceName);
            this.metricName(model.metricName);
            this.period(model.period);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.unit(model.unit);
            this.statistics(model.statistics);
        }

        public final String getInstanceName() {
            return this.instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public final String getMetricName() {
            return this.metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        @Override
        public final Builder metricName(InstanceMetricName metricName) {
            this.metricName(metricName.toString());
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final Integer getPeriod() {
            return this.period;
        }

        @Override
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getUnit() {
            return this.unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(MetricUnit unit) {
            this.unit(unit.toString());
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        public final Collection<String> getStatistics() {
            return this.statistics;
        }

        @Override
        public final Builder statistics(Collection<String> statistics) {
            this.statistics = MetricStatisticListCopier.copy(statistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statistics(String ... statistics) {
            this.statistics(Arrays.asList(statistics));
            return this;
        }

        public final void setStatistics(Collection<String> statistics) {
            this.statistics = MetricStatisticListCopier.copy(statistics);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetInstanceMetricDataRequest build() {
            return new GetInstanceMetricDataRequest(this);
        }
    }

    public static interface Builder
    extends LightsailRequest.Builder,
    CopyableBuilder<Builder, GetInstanceMetricDataRequest> {
        public Builder instanceName(String var1);

        public Builder metricName(String var1);

        public Builder metricName(InstanceMetricName var1);

        public Builder period(Integer var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder unit(String var1);

        public Builder unit(MetricUnit var1);

        public Builder statistics(Collection<String> var1);

        public Builder statistics(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

