/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.lightsail.model.LightsailResponse;
import software.amazon.awssdk.services.lightsail.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetActiveNamesResponse
extends LightsailResponse
implements ToCopyableBuilder<Builder, GetActiveNamesResponse> {
    private final List<String> activeNames;
    private final String nextPageToken;

    private GetActiveNamesResponse(BuilderImpl builder) {
        super(builder);
        this.activeNames = builder.activeNames;
        this.nextPageToken = builder.nextPageToken;
    }

    public List<String> activeNames() {
        return this.activeNames;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.activeNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetActiveNamesResponse)) {
            return false;
        }
        GetActiveNamesResponse other = (GetActiveNamesResponse)((Object)obj);
        return Objects.equals(this.activeNames(), other.activeNames()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public String toString() {
        return ToString.builder((String)"GetActiveNamesResponse").add("ActiveNames", this.activeNames()).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "activeNames": {
                return Optional.of(clazz.cast(this.activeNames()));
            }
            case "nextPageToken": {
                return Optional.of(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends LightsailResponse.BuilderImpl
    implements Builder {
        private List<String> activeNames;
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetActiveNamesResponse model) {
            super(model);
            this.activeNames(model.activeNames);
            this.nextPageToken(model.nextPageToken);
        }

        public final Collection<String> getActiveNames() {
            return this.activeNames;
        }

        @Override
        public final Builder activeNames(Collection<String> activeNames) {
            this.activeNames = StringListCopier.copy(activeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activeNames(String ... activeNames) {
            this.activeNames(Arrays.asList(activeNames));
            return this;
        }

        public final void setActiveNames(Collection<String> activeNames) {
            this.activeNames = StringListCopier.copy(activeNames);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public GetActiveNamesResponse build() {
            return new GetActiveNamesResponse(this);
        }
    }

    public static interface Builder
    extends LightsailResponse.Builder,
    CopyableBuilder<Builder, GetActiveNamesResponse> {
        public Builder activeNames(Collection<String> var1);

        public Builder activeNames(String ... var1);

        public Builder nextPageToken(String var1);
    }
}

