/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.util.Date;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.lightsail.model.InstanceSnapshot;
import software.amazon.awssdk.services.lightsail.transform.ResourceLocationUnmarshaller;

public class InstanceSnapshotUnmarshaller
implements Unmarshaller<InstanceSnapshot, JsonUnmarshallerContext> {
    private static InstanceSnapshotUnmarshaller INSTANCE;

    public InstanceSnapshot unmarshall(JsonUnmarshallerContext context) throws Exception {
        InstanceSnapshot.Builder instanceSnapshotBuilder = InstanceSnapshot.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    instanceSnapshotBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("arn", targetDepth)) {
                    context.nextToken();
                    instanceSnapshotBuilder.arn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("supportCode", targetDepth)) {
                    context.nextToken();
                    instanceSnapshotBuilder.supportCode((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("createdAt", targetDepth)) {
                    context.nextToken();
                    instanceSnapshotBuilder.createdAt((Date)context.getUnmarshaller(Date.class).unmarshall((Object)context));
                }
                if (context.testExpression("location", targetDepth)) {
                    context.nextToken();
                    instanceSnapshotBuilder.location(ResourceLocationUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("resourceType", targetDepth)) {
                    context.nextToken();
                    instanceSnapshotBuilder.resourceType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("state", targetDepth)) {
                    context.nextToken();
                    instanceSnapshotBuilder.state((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("progress", targetDepth)) {
                    context.nextToken();
                    instanceSnapshotBuilder.progress((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("fromInstanceName", targetDepth)) {
                    context.nextToken();
                    instanceSnapshotBuilder.fromInstanceName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("fromInstanceArn", targetDepth)) {
                    context.nextToken();
                    instanceSnapshotBuilder.fromInstanceArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("fromBlueprintId", targetDepth)) {
                    context.nextToken();
                    instanceSnapshotBuilder.fromBlueprintId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("fromBundleId", targetDepth)) {
                    context.nextToken();
                    instanceSnapshotBuilder.fromBundleId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("sizeInGb", targetDepth)) {
                    context.nextToken();
                    instanceSnapshotBuilder.sizeInGb((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (InstanceSnapshot)instanceSnapshotBuilder.build();
    }

    public static InstanceSnapshotUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new InstanceSnapshotUnmarshaller();
        }
        return INSTANCE;
    }
}

