/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanagerusersubscriptions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.LicenseServerEndpointProvisioningStatus;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.LicenseServerHealthStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LicenseServer
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LicenseServer> {
    private static final SdkField<String> PROVISIONING_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProvisioningStatus").getter(LicenseServer.getter(LicenseServer::provisioningStatusAsString)).setter(LicenseServer.setter(Builder::provisioningStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningStatus").build()}).build();
    private static final SdkField<String> HEALTH_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HealthStatus").getter(LicenseServer.getter(LicenseServer::healthStatusAsString)).setter(LicenseServer.setter(Builder::healthStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthStatus").build()}).build();
    private static final SdkField<String> IPV4_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ipv4Address").getter(LicenseServer.getter(LicenseServer::ipv4Address)).setter(LicenseServer.setter(Builder::ipv4Address)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv4Address").build()}).build();
    private static final SdkField<String> IPV6_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ipv6Address").getter(LicenseServer.getter(LicenseServer::ipv6Address)).setter(LicenseServer.setter(Builder::ipv6Address)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Address").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVISIONING_STATUS_FIELD, HEALTH_STATUS_FIELD, IPV4_ADDRESS_FIELD, IPV6_ADDRESS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LicenseServer.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String provisioningStatus;
    private final String healthStatus;
    private final String ipv4Address;
    private final String ipv6Address;

    private LicenseServer(BuilderImpl builder) {
        this.provisioningStatus = builder.provisioningStatus;
        this.healthStatus = builder.healthStatus;
        this.ipv4Address = builder.ipv4Address;
        this.ipv6Address = builder.ipv6Address;
    }

    public final LicenseServerEndpointProvisioningStatus provisioningStatus() {
        return LicenseServerEndpointProvisioningStatus.fromValue(this.provisioningStatus);
    }

    public final String provisioningStatusAsString() {
        return this.provisioningStatus;
    }

    public final LicenseServerHealthStatus healthStatus() {
        return LicenseServerHealthStatus.fromValue(this.healthStatus);
    }

    public final String healthStatusAsString() {
        return this.healthStatus;
    }

    public final String ipv4Address() {
        return this.ipv4Address;
    }

    public final String ipv6Address() {
        return this.ipv6Address;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv4Address());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6Address());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LicenseServer)) {
            return false;
        }
        LicenseServer other = (LicenseServer)obj;
        return Objects.equals(this.provisioningStatusAsString(), other.provisioningStatusAsString()) && Objects.equals(this.healthStatusAsString(), other.healthStatusAsString()) && Objects.equals(this.ipv4Address(), other.ipv4Address()) && Objects.equals(this.ipv6Address(), other.ipv6Address());
    }

    public final String toString() {
        return ToString.builder((String)"LicenseServer").add("ProvisioningStatus", (Object)this.provisioningStatusAsString()).add("HealthStatus", (Object)this.healthStatusAsString()).add("Ipv4Address", (Object)this.ipv4Address()).add("Ipv6Address", (Object)this.ipv6Address()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProvisioningStatus": {
                return Optional.ofNullable(clazz.cast(this.provisioningStatusAsString()));
            }
            case "HealthStatus": {
                return Optional.ofNullable(clazz.cast(this.healthStatusAsString()));
            }
            case "Ipv4Address": {
                return Optional.ofNullable(clazz.cast(this.ipv4Address()));
            }
            case "Ipv6Address": {
                return Optional.ofNullable(clazz.cast(this.ipv6Address()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ProvisioningStatus", PROVISIONING_STATUS_FIELD);
        map.put("HealthStatus", HEALTH_STATUS_FIELD);
        map.put("Ipv4Address", IPV4_ADDRESS_FIELD);
        map.put("Ipv6Address", IPV6_ADDRESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LicenseServer, T> g) {
        return obj -> g.apply((LicenseServer)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String provisioningStatus;
        private String healthStatus;
        private String ipv4Address;
        private String ipv6Address;

        private BuilderImpl() {
        }

        private BuilderImpl(LicenseServer model) {
            this.provisioningStatus(model.provisioningStatus);
            this.healthStatus(model.healthStatus);
            this.ipv4Address(model.ipv4Address);
            this.ipv6Address(model.ipv6Address);
        }

        public final String getProvisioningStatus() {
            return this.provisioningStatus;
        }

        public final void setProvisioningStatus(String provisioningStatus) {
            this.provisioningStatus = provisioningStatus;
        }

        @Override
        public final Builder provisioningStatus(String provisioningStatus) {
            this.provisioningStatus = provisioningStatus;
            return this;
        }

        @Override
        public final Builder provisioningStatus(LicenseServerEndpointProvisioningStatus provisioningStatus) {
            this.provisioningStatus(provisioningStatus == null ? null : provisioningStatus.toString());
            return this;
        }

        public final String getHealthStatus() {
            return this.healthStatus;
        }

        public final void setHealthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
        }

        @Override
        public final Builder healthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
            return this;
        }

        @Override
        public final Builder healthStatus(LicenseServerHealthStatus healthStatus) {
            this.healthStatus(healthStatus == null ? null : healthStatus.toString());
            return this;
        }

        public final String getIpv4Address() {
            return this.ipv4Address;
        }

        public final void setIpv4Address(String ipv4Address) {
            this.ipv4Address = ipv4Address;
        }

        @Override
        public final Builder ipv4Address(String ipv4Address) {
            this.ipv4Address = ipv4Address;
            return this;
        }

        public final String getIpv6Address() {
            return this.ipv6Address;
        }

        public final void setIpv6Address(String ipv6Address) {
            this.ipv6Address = ipv6Address;
        }

        @Override
        public final Builder ipv6Address(String ipv6Address) {
            this.ipv6Address = ipv6Address;
            return this;
        }

        public LicenseServer build() {
            return new LicenseServer(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LicenseServer> {
        public Builder provisioningStatus(String var1);

        public Builder provisioningStatus(LicenseServerEndpointProvisioningStatus var1);

        public Builder healthStatus(String var1);

        public Builder healthStatus(LicenseServerHealthStatus var1);

        public Builder ipv4Address(String var1);

        public Builder ipv6Address(String var1);
    }
}

