/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanagerusersubscriptions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.IdentityProvider;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceSummary> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(InstanceSummary.getter(InstanceSummary::instanceId)).setter(InstanceSummary.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(InstanceSummary.getter(InstanceSummary::status)).setter(InstanceSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<List<String>> PRODUCTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Products").getter(InstanceSummary.getter(InstanceSummary::products)).setter(InstanceSummary.setter(Builder::products)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Products").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LAST_STATUS_CHECK_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastStatusCheckDate").getter(InstanceSummary.getter(InstanceSummary::lastStatusCheckDate)).setter(InstanceSummary.setter(Builder::lastStatusCheckDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastStatusCheckDate").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(InstanceSummary.getter(InstanceSummary::statusMessage)).setter(InstanceSummary.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<String> OWNER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerAccountId").getter(InstanceSummary.getter(InstanceSummary::ownerAccountId)).setter(InstanceSummary.setter(Builder::ownerAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAccountId").build()}).build();
    private static final SdkField<IdentityProvider> IDENTITY_PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IdentityProvider").getter(InstanceSummary.getter(InstanceSummary::identityProvider)).setter(InstanceSummary.setter(Builder::identityProvider)).constructor(IdentityProvider::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProvider").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, STATUS_FIELD, PRODUCTS_FIELD, LAST_STATUS_CHECK_DATE_FIELD, STATUS_MESSAGE_FIELD, OWNER_ACCOUNT_ID_FIELD, IDENTITY_PROVIDER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InstanceSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String instanceId;
    private final String status;
    private final List<String> products;
    private final String lastStatusCheckDate;
    private final String statusMessage;
    private final String ownerAccountId;
    private final IdentityProvider identityProvider;

    private InstanceSummary(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.status = builder.status;
        this.products = builder.products;
        this.lastStatusCheckDate = builder.lastStatusCheckDate;
        this.statusMessage = builder.statusMessage;
        this.ownerAccountId = builder.ownerAccountId;
        this.identityProvider = builder.identityProvider;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String status() {
        return this.status;
    }

    public final boolean hasProducts() {
        return this.products != null && !(this.products instanceof SdkAutoConstructList);
    }

    public final List<String> products() {
        return this.products;
    }

    public final String lastStatusCheckDate() {
        return this.lastStatusCheckDate;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final String ownerAccountId() {
        return this.ownerAccountId;
    }

    public final IdentityProvider identityProvider() {
        return this.identityProvider;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProducts() ? this.products() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastStatusCheckDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityProvider());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceSummary)) {
            return false;
        }
        InstanceSummary other = (InstanceSummary)obj;
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.status(), other.status()) && this.hasProducts() == other.hasProducts() && Objects.equals(this.products(), other.products()) && Objects.equals(this.lastStatusCheckDate(), other.lastStatusCheckDate()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.ownerAccountId(), other.ownerAccountId()) && Objects.equals(this.identityProvider(), other.identityProvider());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceSummary").add("InstanceId", (Object)this.instanceId()).add("Status", (Object)this.status()).add("Products", this.hasProducts() ? this.products() : null).add("LastStatusCheckDate", (Object)this.lastStatusCheckDate()).add("StatusMessage", (Object)this.statusMessage()).add("OwnerAccountId", (Object)this.ownerAccountId()).add("IdentityProvider", (Object)this.identityProvider()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "Products": {
                return Optional.ofNullable(clazz.cast(this.products()));
            }
            case "LastStatusCheckDate": {
                return Optional.ofNullable(clazz.cast(this.lastStatusCheckDate()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "OwnerAccountId": {
                return Optional.ofNullable(clazz.cast(this.ownerAccountId()));
            }
            case "IdentityProvider": {
                return Optional.ofNullable(clazz.cast(this.identityProvider()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Products", PRODUCTS_FIELD);
        map.put("LastStatusCheckDate", LAST_STATUS_CHECK_DATE_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("OwnerAccountId", OWNER_ACCOUNT_ID_FIELD);
        map.put("IdentityProvider", IDENTITY_PROVIDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceSummary, T> g) {
        return obj -> g.apply((InstanceSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private String status;
        private List<String> products = DefaultSdkAutoConstructList.getInstance();
        private String lastStatusCheckDate;
        private String statusMessage;
        private String ownerAccountId;
        private IdentityProvider identityProvider;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceSummary model) {
            this.instanceId(model.instanceId);
            this.status(model.status);
            this.products(model.products);
            this.lastStatusCheckDate(model.lastStatusCheckDate);
            this.statusMessage(model.statusMessage);
            this.ownerAccountId(model.ownerAccountId);
            this.identityProvider(model.identityProvider);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Collection<String> getProducts() {
            if (this.products instanceof SdkAutoConstructList) {
                return null;
            }
            return this.products;
        }

        public final void setProducts(Collection<String> products) {
            this.products = StringListCopier.copy(products);
        }

        @Override
        public final Builder products(Collection<String> products) {
            this.products = StringListCopier.copy(products);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder products(String ... products) {
            this.products(Arrays.asList(products));
            return this;
        }

        public final String getLastStatusCheckDate() {
            return this.lastStatusCheckDate;
        }

        public final void setLastStatusCheckDate(String lastStatusCheckDate) {
            this.lastStatusCheckDate = lastStatusCheckDate;
        }

        @Override
        public final Builder lastStatusCheckDate(String lastStatusCheckDate) {
            this.lastStatusCheckDate = lastStatusCheckDate;
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getOwnerAccountId() {
            return this.ownerAccountId;
        }

        public final void setOwnerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
        }

        @Override
        public final Builder ownerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
            return this;
        }

        public final IdentityProvider.Builder getIdentityProvider() {
            return this.identityProvider != null ? this.identityProvider.toBuilder() : null;
        }

        public final void setIdentityProvider(IdentityProvider.BuilderImpl identityProvider) {
            this.identityProvider = identityProvider != null ? identityProvider.build() : null;
        }

        @Override
        public final Builder identityProvider(IdentityProvider identityProvider) {
            this.identityProvider = identityProvider;
            return this;
        }

        public InstanceSummary build() {
            return new InstanceSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceSummary> {
        public Builder instanceId(String var1);

        public Builder status(String var1);

        public Builder products(Collection<String> var1);

        public Builder products(String ... var1);

        public Builder lastStatusCheckDate(String var1);

        public Builder statusMessage(String var1);

        public Builder ownerAccountId(String var1);

        public Builder identityProvider(IdentityProvider var1);

        default public Builder identityProvider(Consumer<IdentityProvider.Builder> identityProvider) {
            return this.identityProvider((IdentityProvider)((IdentityProvider.Builder)IdentityProvider.builder().applyMutation(identityProvider)).build());
        }
    }
}

