/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanagerusersubscriptions;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.LicenseManagerUserSubscriptionsClient;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.LicenseManagerUserSubscriptionsServiceClientConfiguration;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.AccessDeniedException;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.AssociateUserRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.AssociateUserResponse;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ConflictException;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.DeregisterIdentityProviderRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.DeregisterIdentityProviderResponse;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.DisassociateUserRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.DisassociateUserResponse;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.InternalServerException;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.LicenseManagerUserSubscriptionsException;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.LicenseManagerUserSubscriptionsRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListIdentityProvidersRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListIdentityProvidersResponse;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListInstancesRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListInstancesResponse;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListProductSubscriptionsRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListProductSubscriptionsResponse;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListUserAssociationsRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListUserAssociationsResponse;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.RegisterIdentityProviderRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.RegisterIdentityProviderResponse;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ResourceNotFoundException;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.StartProductSubscriptionRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.StartProductSubscriptionResponse;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.StopProductSubscriptionRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.StopProductSubscriptionResponse;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ThrottlingException;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.UpdateIdentityProviderSettingsRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.UpdateIdentityProviderSettingsResponse;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ValidationException;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListIdentityProvidersIterable;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListInstancesIterable;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListProductSubscriptionsIterable;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListUserAssociationsIterable;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.transform.AssociateUserRequestMarshaller;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.transform.DeregisterIdentityProviderRequestMarshaller;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.transform.DisassociateUserRequestMarshaller;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.transform.ListIdentityProvidersRequestMarshaller;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.transform.ListInstancesRequestMarshaller;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.transform.ListProductSubscriptionsRequestMarshaller;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.transform.ListUserAssociationsRequestMarshaller;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.transform.RegisterIdentityProviderRequestMarshaller;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.transform.StartProductSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.transform.StopProductSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.transform.UpdateIdentityProviderSettingsRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultLicenseManagerUserSubscriptionsClient
implements LicenseManagerUserSubscriptionsClient {
    private static final Logger log = Logger.loggerFor(DefaultLicenseManagerUserSubscriptionsClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final LicenseManagerUserSubscriptionsServiceClientConfiguration serviceClientConfiguration;

    protected DefaultLicenseManagerUserSubscriptionsClient(LicenseManagerUserSubscriptionsServiceClientConfiguration serviceClientConfiguration, SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateUserResponse associateUser(AssociateUserRequest associateUserRequest) throws ServiceQuotaExceededException, ConflictException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, LicenseManagerUserSubscriptionsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateUserResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerUserSubscriptionsClient.resolveMetricPublishers(this.clientConfiguration, associateUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager User Subscriptions");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateUser");
            AssociateUserResponse associateUserResponse = (AssociateUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateUser").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociateUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerUserSubscriptionsClient.lambda$associateUser$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeregisterIdentityProviderResponse deregisterIdentityProvider(DeregisterIdentityProviderRequest deregisterIdentityProviderRequest) throws ServiceQuotaExceededException, ConflictException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, LicenseManagerUserSubscriptionsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeregisterIdentityProviderResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerUserSubscriptionsClient.resolveMetricPublishers(this.clientConfiguration, deregisterIdentityProviderRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager User Subscriptions");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeregisterIdentityProvider");
            DeregisterIdentityProviderResponse deregisterIdentityProviderResponse = (DeregisterIdentityProviderResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeregisterIdentityProvider").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deregisterIdentityProviderRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeregisterIdentityProviderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deregisterIdentityProviderResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerUserSubscriptionsClient.lambda$deregisterIdentityProvider$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateUserResponse disassociateUser(DisassociateUserRequest disassociateUserRequest) throws ServiceQuotaExceededException, ConflictException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, LicenseManagerUserSubscriptionsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateUserResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerUserSubscriptionsClient.resolveMetricPublishers(this.clientConfiguration, disassociateUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager User Subscriptions");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateUser");
            DisassociateUserResponse disassociateUserResponse = (DisassociateUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateUser").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerUserSubscriptionsClient.lambda$disassociateUser$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIdentityProvidersResponse listIdentityProviders(ListIdentityProvidersRequest listIdentityProvidersRequest) throws ServiceQuotaExceededException, ConflictException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, LicenseManagerUserSubscriptionsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListIdentityProvidersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerUserSubscriptionsClient.resolveMetricPublishers(this.clientConfiguration, listIdentityProvidersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager User Subscriptions");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListIdentityProviders");
            ListIdentityProvidersResponse listIdentityProvidersResponse = (ListIdentityProvidersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListIdentityProviders").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listIdentityProvidersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListIdentityProvidersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listIdentityProvidersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerUserSubscriptionsClient.lambda$listIdentityProviders$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListIdentityProvidersIterable listIdentityProvidersPaginator(ListIdentityProvidersRequest listIdentityProvidersRequest) throws ServiceQuotaExceededException, ConflictException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, LicenseManagerUserSubscriptionsException {
        return new ListIdentityProvidersIterable(this, this.applyPaginatorUserAgent(listIdentityProvidersRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListInstancesResponse listInstances(ListInstancesRequest listInstancesRequest) throws ServiceQuotaExceededException, ConflictException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, LicenseManagerUserSubscriptionsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListInstancesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerUserSubscriptionsClient.resolveMetricPublishers(this.clientConfiguration, listInstancesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager User Subscriptions");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListInstances");
            ListInstancesResponse listInstancesResponse = (ListInstancesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListInstances").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listInstancesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListInstancesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listInstancesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerUserSubscriptionsClient.lambda$listInstances$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListInstancesIterable listInstancesPaginator(ListInstancesRequest listInstancesRequest) throws ServiceQuotaExceededException, ConflictException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, LicenseManagerUserSubscriptionsException {
        return new ListInstancesIterable(this, this.applyPaginatorUserAgent(listInstancesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListProductSubscriptionsResponse listProductSubscriptions(ListProductSubscriptionsRequest listProductSubscriptionsRequest) throws ServiceQuotaExceededException, ConflictException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, LicenseManagerUserSubscriptionsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListProductSubscriptionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerUserSubscriptionsClient.resolveMetricPublishers(this.clientConfiguration, listProductSubscriptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager User Subscriptions");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListProductSubscriptions");
            ListProductSubscriptionsResponse listProductSubscriptionsResponse = (ListProductSubscriptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListProductSubscriptions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listProductSubscriptionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListProductSubscriptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listProductSubscriptionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerUserSubscriptionsClient.lambda$listProductSubscriptions$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListProductSubscriptionsIterable listProductSubscriptionsPaginator(ListProductSubscriptionsRequest listProductSubscriptionsRequest) throws ServiceQuotaExceededException, ConflictException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, LicenseManagerUserSubscriptionsException {
        return new ListProductSubscriptionsIterable(this, this.applyPaginatorUserAgent(listProductSubscriptionsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListUserAssociationsResponse listUserAssociations(ListUserAssociationsRequest listUserAssociationsRequest) throws ServiceQuotaExceededException, ConflictException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, LicenseManagerUserSubscriptionsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListUserAssociationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerUserSubscriptionsClient.resolveMetricPublishers(this.clientConfiguration, listUserAssociationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager User Subscriptions");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListUserAssociations");
            ListUserAssociationsResponse listUserAssociationsResponse = (ListUserAssociationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListUserAssociations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listUserAssociationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListUserAssociationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listUserAssociationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerUserSubscriptionsClient.lambda$listUserAssociations$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListUserAssociationsIterable listUserAssociationsPaginator(ListUserAssociationsRequest listUserAssociationsRequest) throws ServiceQuotaExceededException, ConflictException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, LicenseManagerUserSubscriptionsException {
        return new ListUserAssociationsIterable(this, this.applyPaginatorUserAgent(listUserAssociationsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterIdentityProviderResponse registerIdentityProvider(RegisterIdentityProviderRequest registerIdentityProviderRequest) throws ServiceQuotaExceededException, ConflictException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, LicenseManagerUserSubscriptionsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterIdentityProviderResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerUserSubscriptionsClient.resolveMetricPublishers(this.clientConfiguration, registerIdentityProviderRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager User Subscriptions");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterIdentityProvider");
            RegisterIdentityProviderResponse registerIdentityProviderResponse = (RegisterIdentityProviderResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterIdentityProvider").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)registerIdentityProviderRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RegisterIdentityProviderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return registerIdentityProviderResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerUserSubscriptionsClient.lambda$registerIdentityProvider$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartProductSubscriptionResponse startProductSubscription(StartProductSubscriptionRequest startProductSubscriptionRequest) throws ServiceQuotaExceededException, ConflictException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, LicenseManagerUserSubscriptionsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartProductSubscriptionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerUserSubscriptionsClient.resolveMetricPublishers(this.clientConfiguration, startProductSubscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager User Subscriptions");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartProductSubscription");
            StartProductSubscriptionResponse startProductSubscriptionResponse = (StartProductSubscriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartProductSubscription").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startProductSubscriptionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartProductSubscriptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startProductSubscriptionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerUserSubscriptionsClient.lambda$startProductSubscription$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopProductSubscriptionResponse stopProductSubscription(StopProductSubscriptionRequest stopProductSubscriptionRequest) throws ServiceQuotaExceededException, ConflictException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, LicenseManagerUserSubscriptionsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopProductSubscriptionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerUserSubscriptionsClient.resolveMetricPublishers(this.clientConfiguration, stopProductSubscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager User Subscriptions");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopProductSubscription");
            StopProductSubscriptionResponse stopProductSubscriptionResponse = (StopProductSubscriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopProductSubscription").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopProductSubscriptionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopProductSubscriptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopProductSubscriptionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerUserSubscriptionsClient.lambda$stopProductSubscription$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateIdentityProviderSettingsResponse updateIdentityProviderSettings(UpdateIdentityProviderSettingsRequest updateIdentityProviderSettingsRequest) throws ValidationException, ThrottlingException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, LicenseManagerUserSubscriptionsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateIdentityProviderSettingsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerUserSubscriptionsClient.resolveMetricPublishers(this.clientConfiguration, updateIdentityProviderSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager User Subscriptions");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateIdentityProviderSettings");
            UpdateIdentityProviderSettingsResponse updateIdentityProviderSettingsResponse = (UpdateIdentityProviderSettingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateIdentityProviderSettings").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateIdentityProviderSettingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateIdentityProviderSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateIdentityProviderSettingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerUserSubscriptionsClient.lambda$updateIdentityProviderSettings$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private <T extends LicenseManagerUserSubscriptionsRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.20.48").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((LicenseManagerUserSubscriptionsRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public final String serviceName() {
        return "license-manager-user-subscriptions";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(LicenseManagerUserSubscriptionsException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).build());
    }

    @Override
    public final LicenseManagerUserSubscriptionsServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateIdentityProviderSettings$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopProductSubscription$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startProductSubscription$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$registerIdentityProvider$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listUserAssociations$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listProductSubscriptions$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listInstances$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listIdentityProviders$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateUser$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deregisterIdentityProvider$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateUser$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

