/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateServiceSettingsRequest extends LicenseManagerLinuxSubscriptionsRequest implements
        ToCopyableBuilder<UpdateServiceSettingsRequest.Builder, UpdateServiceSettingsRequest> {
    private static final SdkField<Boolean> ALLOW_UPDATE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AllowUpdate").getter(getter(UpdateServiceSettingsRequest::allowUpdate))
            .setter(setter(Builder::allowUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowUpdate").build()).build();

    private static final SdkField<String> LINUX_SUBSCRIPTIONS_DISCOVERY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LinuxSubscriptionsDiscovery")
            .getter(getter(UpdateServiceSettingsRequest::linuxSubscriptionsDiscoveryAsString))
            .setter(setter(Builder::linuxSubscriptionsDiscovery))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinuxSubscriptionsDiscovery")
                    .build()).build();

    private static final SdkField<LinuxSubscriptionsDiscoverySettings> LINUX_SUBSCRIPTIONS_DISCOVERY_SETTINGS_FIELD = SdkField
            .<LinuxSubscriptionsDiscoverySettings> builder(MarshallingType.SDK_POJO)
            .memberName("LinuxSubscriptionsDiscoverySettings")
            .getter(getter(UpdateServiceSettingsRequest::linuxSubscriptionsDiscoverySettings))
            .setter(setter(Builder::linuxSubscriptionsDiscoverySettings))
            .constructor(LinuxSubscriptionsDiscoverySettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("LinuxSubscriptionsDiscoverySettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOW_UPDATE_FIELD,
            LINUX_SUBSCRIPTIONS_DISCOVERY_FIELD, LINUX_SUBSCRIPTIONS_DISCOVERY_SETTINGS_FIELD));

    private final Boolean allowUpdate;

    private final String linuxSubscriptionsDiscovery;

    private final LinuxSubscriptionsDiscoverySettings linuxSubscriptionsDiscoverySettings;

    private UpdateServiceSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.allowUpdate = builder.allowUpdate;
        this.linuxSubscriptionsDiscovery = builder.linuxSubscriptionsDiscovery;
        this.linuxSubscriptionsDiscoverySettings = builder.linuxSubscriptionsDiscoverySettings;
    }

    /**
     * <p>
     * Describes if updates are allowed to the service settings for Linux subscriptions. If you allow updates, you can
     * aggregate Linux subscription data in more than one home Region.
     * </p>
     * 
     * @return Describes if updates are allowed to the service settings for Linux subscriptions. If you allow updates,
     *         you can aggregate Linux subscription data in more than one home Region.
     */
    public final Boolean allowUpdate() {
        return allowUpdate;
    }

    /**
     * <p>
     * Describes if the discovery of Linux subscriptions is enabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #linuxSubscriptionsDiscovery} will return {@link LinuxSubscriptionsDiscovery#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #linuxSubscriptionsDiscoveryAsString}.
     * </p>
     * 
     * @return Describes if the discovery of Linux subscriptions is enabled.
     * @see LinuxSubscriptionsDiscovery
     */
    public final LinuxSubscriptionsDiscovery linuxSubscriptionsDiscovery() {
        return LinuxSubscriptionsDiscovery.fromValue(linuxSubscriptionsDiscovery);
    }

    /**
     * <p>
     * Describes if the discovery of Linux subscriptions is enabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #linuxSubscriptionsDiscovery} will return {@link LinuxSubscriptionsDiscovery#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #linuxSubscriptionsDiscoveryAsString}.
     * </p>
     * 
     * @return Describes if the discovery of Linux subscriptions is enabled.
     * @see LinuxSubscriptionsDiscovery
     */
    public final String linuxSubscriptionsDiscoveryAsString() {
        return linuxSubscriptionsDiscovery;
    }

    /**
     * <p>
     * The settings defined for Linux subscriptions discovery. The settings include if Organizations integration has
     * been enabled, and which Regions data will be aggregated from.
     * </p>
     * 
     * @return The settings defined for Linux subscriptions discovery. The settings include if Organizations integration
     *         has been enabled, and which Regions data will be aggregated from.
     */
    public final LinuxSubscriptionsDiscoverySettings linuxSubscriptionsDiscoverySettings() {
        return linuxSubscriptionsDiscoverySettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(allowUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(linuxSubscriptionsDiscoveryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(linuxSubscriptionsDiscoverySettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateServiceSettingsRequest)) {
            return false;
        }
        UpdateServiceSettingsRequest other = (UpdateServiceSettingsRequest) obj;
        return Objects.equals(allowUpdate(), other.allowUpdate())
                && Objects.equals(linuxSubscriptionsDiscoveryAsString(), other.linuxSubscriptionsDiscoveryAsString())
                && Objects.equals(linuxSubscriptionsDiscoverySettings(), other.linuxSubscriptionsDiscoverySettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateServiceSettingsRequest").add("AllowUpdate", allowUpdate())
                .add("LinuxSubscriptionsDiscovery", linuxSubscriptionsDiscoveryAsString())
                .add("LinuxSubscriptionsDiscoverySettings", linuxSubscriptionsDiscoverySettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllowUpdate":
            return Optional.ofNullable(clazz.cast(allowUpdate()));
        case "LinuxSubscriptionsDiscovery":
            return Optional.ofNullable(clazz.cast(linuxSubscriptionsDiscoveryAsString()));
        case "LinuxSubscriptionsDiscoverySettings":
            return Optional.ofNullable(clazz.cast(linuxSubscriptionsDiscoverySettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateServiceSettingsRequest, T> g) {
        return obj -> g.apply((UpdateServiceSettingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LicenseManagerLinuxSubscriptionsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateServiceSettingsRequest> {
        /**
         * <p>
         * Describes if updates are allowed to the service settings for Linux subscriptions. If you allow updates, you
         * can aggregate Linux subscription data in more than one home Region.
         * </p>
         * 
         * @param allowUpdate
         *        Describes if updates are allowed to the service settings for Linux subscriptions. If you allow
         *        updates, you can aggregate Linux subscription data in more than one home Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowUpdate(Boolean allowUpdate);

        /**
         * <p>
         * Describes if the discovery of Linux subscriptions is enabled.
         * </p>
         * 
         * @param linuxSubscriptionsDiscovery
         *        Describes if the discovery of Linux subscriptions is enabled.
         * @see LinuxSubscriptionsDiscovery
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LinuxSubscriptionsDiscovery
         */
        Builder linuxSubscriptionsDiscovery(String linuxSubscriptionsDiscovery);

        /**
         * <p>
         * Describes if the discovery of Linux subscriptions is enabled.
         * </p>
         * 
         * @param linuxSubscriptionsDiscovery
         *        Describes if the discovery of Linux subscriptions is enabled.
         * @see LinuxSubscriptionsDiscovery
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LinuxSubscriptionsDiscovery
         */
        Builder linuxSubscriptionsDiscovery(LinuxSubscriptionsDiscovery linuxSubscriptionsDiscovery);

        /**
         * <p>
         * The settings defined for Linux subscriptions discovery. The settings include if Organizations integration has
         * been enabled, and which Regions data will be aggregated from.
         * </p>
         * 
         * @param linuxSubscriptionsDiscoverySettings
         *        The settings defined for Linux subscriptions discovery. The settings include if Organizations
         *        integration has been enabled, and which Regions data will be aggregated from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linuxSubscriptionsDiscoverySettings(LinuxSubscriptionsDiscoverySettings linuxSubscriptionsDiscoverySettings);

        /**
         * <p>
         * The settings defined for Linux subscriptions discovery. The settings include if Organizations integration has
         * been enabled, and which Regions data will be aggregated from.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link LinuxSubscriptionsDiscoverySettings.Builder} avoiding the need to create one manually via
         * {@link LinuxSubscriptionsDiscoverySettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LinuxSubscriptionsDiscoverySettings.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #linuxSubscriptionsDiscoverySettings(LinuxSubscriptionsDiscoverySettings)}.
         * 
         * @param linuxSubscriptionsDiscoverySettings
         *        a consumer that will call methods on {@link LinuxSubscriptionsDiscoverySettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #linuxSubscriptionsDiscoverySettings(LinuxSubscriptionsDiscoverySettings)
         */
        default Builder linuxSubscriptionsDiscoverySettings(
                Consumer<LinuxSubscriptionsDiscoverySettings.Builder> linuxSubscriptionsDiscoverySettings) {
            return linuxSubscriptionsDiscoverySettings(LinuxSubscriptionsDiscoverySettings.builder()
                    .applyMutation(linuxSubscriptionsDiscoverySettings).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LicenseManagerLinuxSubscriptionsRequest.BuilderImpl implements Builder {
        private Boolean allowUpdate;

        private String linuxSubscriptionsDiscovery;

        private LinuxSubscriptionsDiscoverySettings linuxSubscriptionsDiscoverySettings;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateServiceSettingsRequest model) {
            super(model);
            allowUpdate(model.allowUpdate);
            linuxSubscriptionsDiscovery(model.linuxSubscriptionsDiscovery);
            linuxSubscriptionsDiscoverySettings(model.linuxSubscriptionsDiscoverySettings);
        }

        public final Boolean getAllowUpdate() {
            return allowUpdate;
        }

        public final void setAllowUpdate(Boolean allowUpdate) {
            this.allowUpdate = allowUpdate;
        }

        @Override
        public final Builder allowUpdate(Boolean allowUpdate) {
            this.allowUpdate = allowUpdate;
            return this;
        }

        public final String getLinuxSubscriptionsDiscovery() {
            return linuxSubscriptionsDiscovery;
        }

        public final void setLinuxSubscriptionsDiscovery(String linuxSubscriptionsDiscovery) {
            this.linuxSubscriptionsDiscovery = linuxSubscriptionsDiscovery;
        }

        @Override
        public final Builder linuxSubscriptionsDiscovery(String linuxSubscriptionsDiscovery) {
            this.linuxSubscriptionsDiscovery = linuxSubscriptionsDiscovery;
            return this;
        }

        @Override
        public final Builder linuxSubscriptionsDiscovery(LinuxSubscriptionsDiscovery linuxSubscriptionsDiscovery) {
            this.linuxSubscriptionsDiscovery(linuxSubscriptionsDiscovery == null ? null : linuxSubscriptionsDiscovery.toString());
            return this;
        }

        public final LinuxSubscriptionsDiscoverySettings.Builder getLinuxSubscriptionsDiscoverySettings() {
            return linuxSubscriptionsDiscoverySettings != null ? linuxSubscriptionsDiscoverySettings.toBuilder() : null;
        }

        public final void setLinuxSubscriptionsDiscoverySettings(
                LinuxSubscriptionsDiscoverySettings.BuilderImpl linuxSubscriptionsDiscoverySettings) {
            this.linuxSubscriptionsDiscoverySettings = linuxSubscriptionsDiscoverySettings != null ? linuxSubscriptionsDiscoverySettings
                    .build() : null;
        }

        @Override
        public final Builder linuxSubscriptionsDiscoverySettings(
                LinuxSubscriptionsDiscoverySettings linuxSubscriptionsDiscoverySettings) {
            this.linuxSubscriptionsDiscoverySettings = linuxSubscriptionsDiscoverySettings;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateServiceSettingsRequest build() {
            return new UpdateServiceSettingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
