/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.licensemanager.model.LicenseManagerResponse;
import software.amazon.awssdk.services.licensemanager.model.LicenseSpecification;
import software.amazon.awssdk.services.licensemanager.model.LicenseSpecificationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLicenseSpecificationsForResourceResponse
extends LicenseManagerResponse
implements ToCopyableBuilder<Builder, ListLicenseSpecificationsForResourceResponse> {
    private static final SdkField<List<LicenseSpecification>> LICENSE_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListLicenseSpecificationsForResourceResponse.getter(ListLicenseSpecificationsForResourceResponse::licenseSpecifications)).setter(ListLicenseSpecificationsForResourceResponse.setter(Builder::licenseSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseSpecifications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LicenseSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListLicenseSpecificationsForResourceResponse.getter(ListLicenseSpecificationsForResourceResponse::nextToken)).setter(ListLicenseSpecificationsForResourceResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LICENSE_SPECIFICATIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<LicenseSpecification> licenseSpecifications;
    private final String nextToken;

    private ListLicenseSpecificationsForResourceResponse(BuilderImpl builder) {
        super(builder);
        this.licenseSpecifications = builder.licenseSpecifications;
        this.nextToken = builder.nextToken;
    }

    public List<LicenseSpecification> licenseSpecifications() {
        return this.licenseSpecifications;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseSpecifications());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLicenseSpecificationsForResourceResponse)) {
            return false;
        }
        ListLicenseSpecificationsForResourceResponse other = (ListLicenseSpecificationsForResourceResponse)((Object)obj);
        return Objects.equals(this.licenseSpecifications(), other.licenseSpecifications()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListLicenseSpecificationsForResourceResponse").add("LicenseSpecifications", this.licenseSpecifications()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LicenseSpecifications": {
                return Optional.ofNullable(clazz.cast(this.licenseSpecifications()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLicenseSpecificationsForResourceResponse, T> g) {
        return obj -> g.apply((ListLicenseSpecificationsForResourceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LicenseManagerResponse.BuilderImpl
    implements Builder {
        private List<LicenseSpecification> licenseSpecifications = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLicenseSpecificationsForResourceResponse model) {
            super(model);
            this.licenseSpecifications(model.licenseSpecifications);
            this.nextToken(model.nextToken);
        }

        public final Collection<LicenseSpecification.Builder> getLicenseSpecifications() {
            return this.licenseSpecifications != null ? (Collection)this.licenseSpecifications.stream().map(LicenseSpecification::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder licenseSpecifications(Collection<LicenseSpecification> licenseSpecifications) {
            this.licenseSpecifications = LicenseSpecificationsCopier.copy(licenseSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseSpecifications(LicenseSpecification ... licenseSpecifications) {
            this.licenseSpecifications(Arrays.asList(licenseSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseSpecifications(Consumer<LicenseSpecification.Builder> ... licenseSpecifications) {
            this.licenseSpecifications(Stream.of(licenseSpecifications).map(c -> (LicenseSpecification)((LicenseSpecification.Builder)LicenseSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLicenseSpecifications(Collection<LicenseSpecification.BuilderImpl> licenseSpecifications) {
            this.licenseSpecifications = LicenseSpecificationsCopier.copyFromBuilder(licenseSpecifications);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListLicenseSpecificationsForResourceResponse build() {
            return new ListLicenseSpecificationsForResourceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LicenseManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLicenseSpecificationsForResourceResponse> {
        public Builder licenseSpecifications(Collection<LicenseSpecification> var1);

        public Builder licenseSpecifications(LicenseSpecification ... var1);

        public Builder licenseSpecifications(Consumer<LicenseSpecification.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

